/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.formatter.consumer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.ANameFormatter;
import com.wily.powerpack.webservices.WSMUtils;

public class WorkshopControlFormatter
extends ANameFormatter {
    public WorkshopControlFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getOperation(InvocationData data) {
        String name = null;
        Object method = data.getInvocationParameterAsObject(0);
        try {
            name = (String)WSMUtils.invokeMethodOnObject(method, "getName");
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", t);
        }
        return name == null ? "UnknownOperationName" : name;
    }

    @Override
    public String getServiceName(InvocationData data) {
        Object endpoint;
        String name = null;
        Object stub = data.getInvocationObject();
        try {
            endpoint = WSMUtils.invokeMethodOnObject(stub, "getEndPoint");
            if (endpoint != null) {
                name = WSMUtils.toString(endpoint);
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        if (name == null) {
            try {
                endpoint = WSMUtils.invokeMethodOnObject(stub, "getServiceCtrlHttpUrl");
                if (endpoint == null) {
                    endpoint = WSMUtils.invokeMethodOnObject(stub, "getServiceCtrlJmsUrl");
                }
                if (endpoint != null) {
                    name = WSMUtils.toString(endpoint);
                }
            }
            catch (Throwable t) {
                WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
            }
        }
        return (name = WSMUtils.formatURLToBeResourceSafe(name)) == null ? "UnknownService" : name;
    }
}

