/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.CompressingAgentMetricDataSet2;
import com.wily.introscope.spec.metric.HistoricAgentMetricDataSet;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.StringTimeslicedValue;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.wilyassert.Assertion;
import java.io.InvalidClassException;

class TimesliceAgentCommand
implements IAgentCommand {
    private final String fAgentBridgeName;
    private final IsengardServerConnectionManager fManager;
    private final AgentMetricData[] fBindings;
    private final AgentMetric[] fDeadMetrics;
    private final boolean fIsFirstTimeSlice;
    private final long fSizeInMetrics;
    private final long fTimeStamp;
    private volatile long fSizeInBytes = 0L;

    public TimesliceAgentCommand(String agentBridgeName, IsengardServerConnectionManager manager, AgentMetricData[] bindings, AgentMetric[] deadMetrics, boolean firstTimeSlice) {
        this.fAgentBridgeName = agentBridgeName;
        this.fManager = manager;
        this.fBindings = bindings;
        this.fDeadMetrics = deadMetrics;
        this.fIsFirstTimeSlice = firstTimeSlice;
        this.fSizeInMetrics = bindings.length;
        this.fTimeStamp = System.currentTimeMillis();
        this.checkBindings();
    }

    private void checkBindings() {
        for (int i = 0; i < this.fBindings.length; ++i) {
            if (this.fBindings[i].getAgentMetric() != AgentMetric.kNullAgentMetric) continue;
            Assertion.wilyAssert(false);
        }
    }

    private AgentMetricData[] getStringConstantMetrics() {
        int count = 0;
        for (AgentMetricData m : this.fBindings) {
            ATimeslicedValue t = m.getTimeslicedValue();
            if (!(t instanceof StringTimeslicedValue)) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        AgentMetricData[] constants = new AgentMetricData[count];
        int i = 0;
        for (AgentMetricData m : this.fBindings) {
            ATimeslicedValue t = m.getTimeslicedValue();
            if (!(t instanceof StringTimeslicedValue)) continue;
            constants[i] = m;
            ++i;
        }
        return constants;
    }

    @Override
    public void handleAgentCommand() throws Exception {
        IAgentBridgeService agentBridge = this.fManager.getAgentBridgeServiceByName(this.fAgentBridgeName);
        boolean sent = false;
        if (this.fBindings.length > 0) {
            long currentTime;
            long metricTime;
            if (IsengardServerConnectionManager.getSendHistoricalData() && (metricTime = this.fBindings[0].getTimeslicedValue().getStopTimestampInMillis()) < (currentTime = System.currentTimeMillis()) - this.fManager.getAgentHarvestTimeMillis()) {
                try {
                    agentBridge.recordTimesliceBindingList(new HistoricAgentMetricDataSet(this.fBindings, currentTime));
                    sent = true;
                    AgentMetricData[] constants = this.getStringConstantMetrics();
                    agentBridge.recordTimesliceBindingList(this.fBindings);
                }
                catch (MessageUndeliverableException mue) {
                    this.fManager.getFeedbackChannel().debug("Failed to send metric timeslice to server:", mue);
                    Throwable cause = mue.getCause();
                    if (cause instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError || cause instanceof InvalidClassException) {
                        this.fManager.getFeedbackChannel().info("Server does not support historical metric data. Turning off metric data buffering feature.");
                        this.fManager.setSendHistoricalData(false);
                    }
                    throw mue;
                }
            }
            if (!sent) {
                if (System.getProperty("com.wily.introscope.agent.usecompresseddata", "true").equals("true")) {
                    agentBridge.recordTimesliceBindingList(new CompressingAgentMetricDataSet2(this.fBindings));
                } else {
                    agentBridge.recordTimesliceBindingList(this.fBindings);
                }
            }
        }
        if (this.fDeadMetrics.length > 0) {
            agentBridge.handleMetricsWentAway(this.fDeadMetrics);
        }
    }

    public boolean isFirstTimeslice() {
        return this.fIsFirstTimeSlice;
    }

    public long getSizeInBytes() {
        if (this.fSizeInBytes == 0L) {
            this.fSizeInBytes = this.getObjectSize();
        }
        return this.fSizeInBytes;
    }

    public long getSizeInMetrics() {
        return this.fSizeInMetrics;
    }

    public long getTimestamp() {
        return this.fTimeStamp;
    }

    private long getObjectSize() {
        long size = AInstrumentationHelper.getObjectSize(this);
        if (size == -1L) {
            return -1L;
        }
        size += AInstrumentationHelper.getObjectSize(this.fBindings);
        size += AInstrumentationHelper.getObjectSize(this.fDeadMetrics);
        for (AgentMetricData binding : this.fBindings) {
            size += AInstrumentationHelper.getObjectSize(binding);
            size += AInstrumentationHelper.getObjectSize(binding.getTimeslicedValue());
        }
        return size;
    }
}

