/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.springboot.actuator;

import com.ca.apm.agent.jmxclient.Configuration;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.Glob;
import java.util.Arrays;

public class ActuatorProperties {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    public static final String SKIP_METRIC_PROP = "introscope.agent.remotejmx.springboot.metricEndpoint.skip.metricName";
    private static Glob[] skipMetrics = new Glob[0];
    public static final String SKIP_TAG_PROP = "introscope.agent.remotejmx.springboot.metricEndpoint.skip.tagName";
    private static Glob[] skipTags = new Glob[0];
    public static final String SKIP_STATISTIC_PROP = "introscope.agent.remotejmx.springboot.metricEndpoint.skip.statisticName";
    private static Glob[] skipStatistics = new Glob[0];
    private static volatile IAgent agent = null;

    public static void initProperties() {
        skipMetrics = ActuatorProperties.transferProperty(agent.IAgent_getIndexedProperties().getProperty(SKIP_METRIC_PROP, ""));
        skipTags = ActuatorProperties.transferProperty(agent.IAgent_getIndexedProperties().getProperty(SKIP_TAG_PROP, ""));
        skipStatistics = ActuatorProperties.transferProperty(agent.IAgent_getIndexedProperties().getProperty(SKIP_STATISTIC_PROP, ""));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebugMessage("introscope.agent.remotejmx.springboot.metricEndpoint.skip.metricName is set to " + Arrays.deepToString(skipMetrics));
            LOGGER.logDebugMessage("introscope.agent.remotejmx.springboot.metricEndpoint.skip.tagName is set to " + Arrays.deepToString(skipTags));
            LOGGER.logDebugMessage("introscope.agent.remotejmx.springboot.metricEndpoint.skip.statisticName is set to " + Arrays.deepToString(skipStatistics));
        }
    }

    private static Glob[] transferProperty(String property) {
        String[] values = property.split(",");
        Glob[] results = new Glob[values.length];
        int i = 0;
        for (String value : values) {
            results[i] = new Glob(value);
            ++i;
        }
        return results;
    }

    public static boolean shouldSkipMetrics(String input) {
        return ActuatorProperties.shouldSkip(input, skipMetrics);
    }

    public static boolean shouldSkipTags(String input) {
        return ActuatorProperties.shouldSkip(input, skipTags);
    }

    public static boolean shouldSkipStatistics(String input) {
        return ActuatorProperties.shouldSkip(input, skipStatistics);
    }

    private static boolean shouldSkip(String input, Glob[] skipGlobs) {
        for (int i = 0; i < skipGlobs.length; ++i) {
            if (!skipGlobs[i].matches(input)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            agent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError((String)"Error while getting Agent instance for generic JMX", (Throwable)e);
        }
    }
}

