/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.pbd;

import com.wily.introscope.agent.upgrade.merge.pbd.DirState;
import com.wily.introscope.agent.upgrade.merge.pbd.Directive;
import com.wily.introscope.agent.upgrade.merge.pbd.Undo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MergePBDs {
    private String wilyOld;
    private String wilyNew;
    private DirState oldState;
    private DirState newState;

    public MergePBDs(String wilyOld, String wilyNew) {
        this.wilyOld = wilyOld;
        this.wilyNew = wilyNew;
        this.oldState = new DirState(wilyOld);
        this.newState = new DirState(wilyNew);
    }

    public void merge() throws IOException {
        for (String pblFile : this.oldState.getPBLFiles()) {
            if (this.newState.hasPBL(pblFile)) {
                this.mergePBL(pblFile);
                continue;
            }
            this.copyFile(this.oldState.getFullPath(pblFile), this.newState.getFullPath(pblFile));
            Undo.markNewFile(this.newState.getFullPath(pblFile));
        }
        for (String pbdFile : this.oldState.getPBDFiles()) {
            if (this.newState.hasPBD(pbdFile)) {
                this.mergePBD(pbdFile);
                continue;
            }
            this.copyFile(this.oldState.getFullPath(pbdFile), this.newState.getFullPath(pbdFile));
            Undo.markNewFile(this.newState.getFullPath(pbdFile));
        }
        Undo.commit();
    }

    private void mergePBL(String file) throws IOException {
        LinkedHashMap<String, Boolean> listedPBDs = new LinkedHashMap<String, Boolean>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.oldState.getFullPath(file)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (!trimmed.endsWith(".pbd")) continue;
                if (trimmed.startsWith("#")) {
                    String pbdFile = trimmed.substring(1).trim();
                    if (listedPBDs.containsKey(pbdFile)) continue;
                    listedPBDs.put(pbdFile, false);
                    continue;
                }
                listedPBDs.put(trimmed, true);
            }
        }
        String newFile = this.newState.getFullPath(file);
        String tempFile = Undo.preserveFile(newFile);
        try (BufferedReader reader = new BufferedReader(new FileReader(tempFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(newFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.endsWith(".pbd")) {
                    String pbdFile = trimmed;
                    boolean isDisabled = false;
                    if (pbdFile.startsWith("#")) {
                        pbdFile = pbdFile.substring(1).trim();
                        isDisabled = true;
                    }
                    if (!listedPBDs.containsKey(pbdFile)) {
                        writer.write(line);
                        writer.newLine();
                        continue;
                    }
                    if (((Boolean)listedPBDs.get(pbdFile)).booleanValue()) {
                        writer.write(pbdFile);
                        writer.newLine();
                    } else {
                        writer.write("#" + pbdFile);
                        writer.newLine();
                    }
                    listedPBDs.remove(pbdFile);
                    continue;
                }
                writer.write(line);
                writer.newLine();
            }
            for (Map.Entry entry : listedPBDs.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    writer.write((String)entry.getKey());
                } else {
                    writer.write("#" + (String)entry.getKey());
                }
                writer.newLine();
            }
        }
    }

    private void mergePBD(String file) throws IOException {
        HashSet<String> groups = new HashSet<String>();
        HashSet<String> tracers = new HashSet<String>();
        HashSet<String> directives = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.newState.getFullPath(file)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String tracer;
                String trimmed = line.trim();
                if (trimmed.startsWith("#") || trimmed.isEmpty()) continue;
                directives.add(trimmed);
                Directive directive = new Directive(trimmed);
                String group = directive.getGroup();
                if (group != null) {
                    groups.add(group);
                }
                if ((tracer = directive.getTracer()) == null) continue;
                tracers.add(tracer);
            }
        }
        Undo.preserveFile(this.newState.getFullPath(file));
        reader = new BufferedReader(new FileReader(this.oldState.getFullPath(file)));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.newState.getFullPath(file), true));){
            String line;
            ArrayList<String> prevComments = new ArrayList<String>();
            boolean firstWrite = true;
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.startsWith("#") || trimmed.isEmpty()) {
                    prevComments.add(line);
                    continue;
                }
                if (directives.contains(trimmed)) {
                    prevComments.clear();
                    continue;
                }
                Directive directive = new Directive(trimmed);
                String group = directive.getGroup();
                String tracer = directive.getTracer();
                if (group == null && tracer == null) {
                    this.appendNew(writer, line, prevComments, firstWrite);
                    firstWrite = false;
                    continue;
                }
                if (group != null && !groups.contains(group)) {
                    this.appendNew(writer, line, prevComments, firstWrite);
                    firstWrite = false;
                    continue;
                }
                if (tracer == null || tracers.contains(tracer)) continue;
                this.appendNew(writer, line, prevComments, firstWrite);
                firstWrite = false;
            }
        }
        finally {
            reader.close();
        }
    }

    private void appendNew(BufferedWriter writer, String line, List<String> prevComments, boolean firstWrite) throws IOException {
        if (firstWrite) {
            writer.write("#############################\n");
            writer.write("# Merged new directives below\n");
            writer.write("#############################\n\n");
        }
        for (String comment : prevComments) {
            writer.write(comment);
            writer.newLine();
        }
        writer.write(line);
        writer.newLine();
        prevComments.clear();
    }

    private void copyFile(String src, String dst) throws IOException {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dst);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
        }
    }
}

