/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.pbd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;

public class Undo {
    private static final String OLD_SUFFIX = ".old";
    private static final Set<String> newFiles = new HashSet<String>();
    private static final Set<String> preservedFiles = new HashSet<String>();

    public static String preserveFile(String path) throws IOException {
        preservedFiles.add(path);
        String oldFile = path + OLD_SUFFIX;
        Files.copy(Paths.get(path, new String[0]), Paths.get(oldFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        return oldFile;
    }

    public static void markNewFile(String path) {
        newFiles.add(path);
    }

    public static void revert() {
        for (String file : new HashSet<String>(newFiles)) {
            try {
                Files.deleteIfExists(Paths.get(file, new String[0]));
            }
            catch (IOException iOException) {}
        }
        newFiles.clear();
        for (String file : new HashSet<String>(preservedFiles)) {
            try {
                Files.deleteIfExists(Paths.get(file, new String[0]));
                Files.move(Paths.get(file + OLD_SUFFIX, new String[0]), Paths.get(file, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {}
        }
        preservedFiles.clear();
    }

    public static void commit() {
        for (String file : new HashSet<String>(preservedFiles)) {
            try {
                Files.deleteIfExists(Paths.get(file + OLD_SUFFIX, new String[0]));
            }
            catch (IOException iOException) {}
        }
        preservedFiles.clear();
        newFiles.clear();
    }
}

