/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.messaging.tracers.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;

public class UMJmsNameFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;
    private final Module module = new Module("UMJmsNameFormatter");

    public UMJmsNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String destName = "Unknown";
        String destType = "Unknown";
        try {
            destName = this.getDestinationName(data);
            if (destName != null) {
                name = StringUtils.replace((String)name, (String)"{destination}", (String)destName);
            }
            if ((destType = this.getDestinationType(data)) != null) {
                name = StringUtils.replace((String)name, (String)"{jmsdestinationtype}", (String)destType);
            }
        }
        catch (Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error(this.module, "Error formatting name in UMJmsNameFormatter: " + e.getMessage());
            this.fAgent.IAgent_getModuleFeedback().debug(this.module, e.getMessage(), (Throwable)e);
        }
        if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.module)) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.module, "UMJmsNameFormatter Final formatted string in JMS name formatter " + name);
        }
        return name;
    }

    private String getDestinationName(InvocationData data) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String destName = null;
        if (data.get("UMJmsDestinationName") != null) {
            return (String)data.get("UMJmsDestinationName");
        }
        Object msg = data.getInvocationParameterAsObject(0);
        destName = (String)ReflectionUtils.invokeMethodOnObject((Object)msg, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{"CA_APM_UM_DESTINATION_NAME"});
        if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.module)) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.module, "UMJmsNameFormatter destination value : " + destName);
        }
        data.put("UMJmsDestinationName", (Object)destName);
        return destName;
    }

    private String getDestinationType(InvocationData data) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String destType = null;
        if (data.get("UMJmsDestinationType") != null) {
            return (String)data.get("UMJmsDestinationType");
        }
        Object msg = data.getInvocationParameterAsObject(0);
        destType = (String)ReflectionUtils.invokeMethodOnObject((Object)msg, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{"CA_APM_UM_DESTINATION_TYPE"});
        data.put("UMJmsDestinationType", (Object)destType);
        return destType;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel arg0, String arg1, InvocationData data) {
        try {
            String destName = this.getDestinationName(data);
            String destType = this.getDestinationType(data);
            if (destName != null && destType != null) {
                return ABlameComponent.getArrayInstance((Object[])new Object[]{destName, destType});
            }
        }
        catch (Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error(this.module, "Error in getKey of UMJmsNameFormatter: " + e.getMessage());
            this.fAgent.IAgent_getModuleFeedback().debug(this.module, e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object getObjectKey(IModuleFeedbackChannel arg0, int arg1, InvocationData data) {
        Object msg = data.getInvocationParameterAsObject(0);
        return msg;
    }
}

