/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.messaging.tracers.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public class UMNameFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;
    private final Module module = new Module("UMNameFormatter");

    public UMNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String destinationName = this.deriveDestinationName(data);
        if (name.contains("{destination}") && destinationName != null) {
            name = StringUtils.replace((String)name, (String)"{destination}", (String)destinationName);
        }
        if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.module)) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.module, "UMNameFormatter Name Constructed is " + name);
        }
        return name;
    }

    private String deriveDestinationName(InvocationData data) {
        String destinationName = null;
        if (data.get("UMJmsDestinationName") != null) {
            return (String)data.get("UMJmsDestinationName");
        }
        Object destination = data.getInvocationObject();
        if (destination != null) {
            try {
                destinationName = (String)ReflectionUtils.invokeMethodOnObject((Object)destination, (String)"getName", (boolean)true, (IModuleFeedbackChannel)this.fAgent.IAgent_getModuleFeedback());
                data.put("UMJmsDestinationName", (Object)destinationName);
                if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.module)) {
                    this.fAgent.IAgent_getModuleFeedback().debug(this.module, "UMNameFormatter , Destination name is " + destinationName);
                }
            }
            catch (Exception e) {
                this.fAgent.IAgent_getModuleFeedback().error(this.module, "Error formatting name in UMNameFormatter: " + e.getMessage());
                this.fAgent.IAgent_getModuleFeedback().debug(this.module, e.getMessage(), (Throwable)e);
            }
        } else if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.module)) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.module, "UMNameFormatter Destination is null");
        }
        return destinationName;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel arg0, String arg1, InvocationData data) {
        String destinationName = this.deriveDestinationName(data);
        if (destinationName != null) {
            try {
                return ABlameComponent.getArrayInstance((Object[])new Object[]{destinationName});
            }
            catch (Exception e) {
                this.fAgent.IAgent_getModuleFeedback().error(this.module, "Error in getKey of UMNameFormatter: " + e.getMessage());
                this.fAgent.IAgent_getModuleFeedback().debug(this.module, e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public Object getObjectKey(IModuleFeedbackChannel arg0, int arg1, InvocationData data) {
        Object destination = data.getInvocationObject();
        return destination;
    }
}

