/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class BizDocTypeNameFormatter
implements ICacheableBlameKeyNameFormatter {
    public static final String kDocTypeNamePlaceHolder = "{doctypename}";
    public static final String kDocTypeNameRegex = "\\{doctypename\\}";
    public static final char[] kIllegalResourceChars = new char[]{':'};
    public static final char kResourceReplacementChar = '_';
    protected final IAgent fAgent;

    public BizDocTypeNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String strDocTypeName = this.getDocumentType(data);
            if (name.indexOf(kDocTypeNamePlaceHolder, 0) >= 0) {
                strDocTypeName = BizDocTypeNameFormatter.formatToBeResourceSafe(strDocTypeName);
                name = name.replaceAll(kDocTypeNameRegex, strDocTypeName);
                if (WMUtils.getLogger().isDebugEnabled()) {
                    WMUtils.getLogger().debug("IN BizDocTypeNameFormatter.INameFormatter_format()AFTER name is " + name);
                }
            }
            WmCache.setDocumentName(strDocTypeName);
            WmCache.setDocumentType(this.getClassname(data));
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        return name;
    }

    private String getDocumentType(InvocationData data) {
        String strDocTypeName = null;
        try {
            Object obj = data.getInvocationObject();
            Object objDoctypeName = obj.getClass().getMethod("get", Integer.TYPE).invoke(obj, 1);
            if (objDoctypeName != null) {
                strDocTypeName = objDoctypeName.toString();
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        if (strDocTypeName == null) {
            strDocTypeName = "UnknownDocumentTypeName";
        }
        return strDocTypeName;
    }

    private String getClassname(InvocationData data) {
        Object obj = data.getInvocationObject();
        return obj.getClass().getSimpleName();
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])kIllegalResourceChars, (char)'_');
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        return null;
    }
}

