/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class ThreadLocalNameFormatter
implements ICacheableBlameKeyNameFormatter {
    public static final String kProcRuleNamePlaceHolder = "{procrule}";
    public static final String kProcRuleNameRegex = "\\{procrule\\}";
    public static final String kUnknownDocumentTypeName = "UnknownDocumentTypeName";
    public static final char[] kIllegalResourceChars = new char[]{':'};
    public static final char kResourceReplacementChar = '_';
    protected final IAgent fAgent;
    protected final IModuleFeedbackChannel logger;

    public ThreadLocalNameFormatter(IAgent agent) {
        this.fAgent = agent;
        this.logger = this.fAgent.IAgent_getModuleFeedback();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String strProcRule = null;
        try {
            if (name.indexOf(kProcRuleNamePlaceHolder, 0) >= 0) {
                strProcRule = WmCache.getRule();
                if (strProcRule == null) {
                    strProcRule = kUnknownDocumentTypeName;
                }
                strProcRule = ThreadLocalNameFormatter.formatToBeResourceSafe(strProcRule);
                name = name.replaceAll(kProcRuleNameRegex, strProcRule);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return name;
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])kIllegalResourceChars, (char)'_');
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        return null;
    }
}

