/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.soa.wm.tn.agent.tracers.WmTNRoutingBlameStack;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;

public class ActivityLogEntryTracer
extends ASingleMetricTracerFactory {
    public static final String kActivityLogEntryError = "createError";
    public static final String kActivityLogEntryWarning = "createWarning";
    public static final String kWarningMessage = "Warning Message";
    public static final String kMessage = "Message";

    public ActivityLogEntryTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String corId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] START:ActivityLogEntryTracer.ITracer_finishTrace() COR ID :" + corId);
        }
        try {
            if (!WmCache.isActivityErrorLoggingEnabled()) {
                return;
            }
            String strMessage = null;
            Object objBriefMessage = data.getInvocationParameterAsObject(2);
            Object objFullMessage = data.getInvocationParameterAsObject(3);
            strMessage = objFullMessage != null ? objFullMessage.toString() : (objBriefMessage != null ? objBriefMessage.toString() : "");
            int type = (Integer)data.getInvocationParameterAsObject(0);
            if (type == 0) {
                this.formatParameterizedName(data);
                if (WMUtils.getLogger().isDebugEnabled()) {
                    WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] ActivityLogEntryTracer:: finish trace Adding ERROR : " + data.getInvocationParameterAsObject(1).toString() + " Message : " + strMessage + " CORID " + corId);
                }
                WmTNRoutingBlameStack.addError(data.getInvocationParameterAsObject(1).toString(), strMessage);
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] END:ActivityLogEntryTracer.ITracer_finishTrace() COR ID " + corId);
        }
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        String corId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] START:ActivityLogEntryTracer.ITracer_startTrace()  Probe Info :" + data.getProbeInformation().getProbeIdentification().getProbeClassName() + " Method Info " + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "COR ID " + corId);
        }
    }

    protected IDataAccumulator createDataAccumulator(String s) {
        return null;
    }
}

