/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.soa.wm.tn.agent.tracers.WmTNRoutingBlameStack;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Vector;

public class BizDocRecognizeTracer
extends BlamePointTracer {
    public BizDocRecognizeTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String corId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BizDocRecognizeTracer.ITracer_finishTrace()CorId:" + corId);
        }
        String error_cls = this.getParameter("error_cls");
        Vector<String> lstErrors = WmTNRoutingBlameStack.getErrors(error_cls);
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BizDocRecognizeTracer.ITracer_finishTrace()Error list :" + lstErrors);
        }
        if (lstErrors != null) {
            super.doStartBlamePointTrace(tracerIndex, data);
            String errorMessage = lstErrors.get(0);
            ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
            ErrorFeature.incrementErrorMetric((IStackElement)data);
            super.ITracer_finishTrace(tracerIndex, data);
        }
        String name = this.formatParameterizedName(data);
        try {
            AgentMetric recognitionMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(name, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
            IRepository current = BlamePointTracer.getCountQueuedRepository((boolean)true);
            IRepository prev = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)recognitionMetric, (IRepository)current);
            if (prev != null) {
                prev.update(BlamePointTracer.getIncreaser(), 0L, data.getWallClockStartTime(), data.getWallClockFinishTime());
            } else {
                current.update(BlamePointTracer.getIncreaser(), 0L, data.getWallClockStartTime(), data.getWallClockFinishTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String corId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BizDocRecognizeTracer.ITracer_startTrace() Probe Info :" + data.getProbeInformation().getProbeIdentification().getProbeClassName() + " Method Info " + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "CorId:" + corId);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setStartCursorAt(element, tracerIndex);
    }

    protected String getComponentName(InvocationData data) {
        String parentname = this.getParameter("ParentResource");
        return parentname;
    }

    public WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean b, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        HashMap<IRepository, AgentMetric[]> metrics = new HashMap<IRepository, AgentMetric[]>(1);
        IRepository errorsSds = null;
        AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(metricName));
        errorsSds = super.getSharedRepositoryNoSharedStructure(true);
        metrics.put(errorsSds, errorMetric);
        WilyTransactionElement result = new WilyTransactionElement(key, metricName, blameStatus, true, parent, previous, start, metrics, null, null, null, errorsSds, null, probeInformation, true, true);
        return result;
    }
}

