/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.soa.wm.tn.agent.tracers.WmTNRoutingBlameStack;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;

public class BlamedAndErrorReportingTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    private final AtomicReference<IRepository> ferrorRep = new AtomicReference();

    public BlamedAndErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String procRule;
        String documentName;
        String documentType;
        String corId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BlamedAndErrorReportingTracer.ITracer_finishTrace()CorId:" + corId);
        }
        String error_cls = this.getParameter("error_cls");
        Vector<String> lstErrors = WmTNRoutingBlameStack.getErrors(error_cls);
        data.put("listErrors", lstErrors);
        if (data.hasInvocationThrownException()) {
            if (WMUtils.getLogger().isDebugEnabled()) {
                WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BlamedAndErrorReportingTracer.error_ITracer_finishTrace()CorId:" + corId);
            }
            this.error_ITracer_finishTrace(tracerIndex, data);
        }
        if ((documentType = WmCache.getDocumentType()) != null) {
            data.put("DocumentType", (Object)documentType);
        }
        if ((documentName = WmCache.getDocumentName()) != null) {
            data.put("DocumentName", (Object)documentName);
        }
        if ((procRule = WmCache.getRule()) != null) {
            data.put("ProcRule", (Object)procRule);
        }
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BlamedAndErrorReportingTracer.ITracer_finishTrace()CorId:" + corId + " docName:" + documentName + " ProcRule :" + procRule);
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BlamedAndErrorReportingTracer.ITracer_finishTrace()CorId:" + corId + " lstErrors:" + lstErrors);
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    private final void recordErrorAtParentResource(String name, long startTime, long endTime) {
        int nDelimiterIndex;
        if (name != null && (nDelimiterIndex = name.indexOf(":")) != -1) {
            try {
                AgentMetric errorMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(name, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                IRepository newError = BlamePointTracer.getCountQueuedRepository((boolean)true);
                IRepository prevError = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)errorMetric, (IRepository)newError);
                if (prevError != null) {
                    this.ferrorRep.set(prevError);
                } else {
                    this.ferrorRep.set(newError);
                }
                this.ferrorRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            }
            catch (Exception e) {
                WMUtils.getLogger().error(e.getMessage());
                WMUtils.getLogger().debug((Throwable)e);
            }
        }
    }

    private final void error_ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            if (WMUtils.getLogger().isDebugEnabled()) {
                ProbeIdentification probe = data.getProbeInformation().getProbeIdentification();
                WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BlamedAndErrorReportingTracer:: " + probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName() + " threw an exception");
            }
            Throwable error = data.getInvocationThrownException();
            String errorMessage = error.getMessage();
            ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
            ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
            ErrorFeature.incrementErrorMetric((IStackElement)data);
            long startTime = data.getWallClockStartTime();
            long endTime = data.getWallClockFinishTime();
            String parentname = this.getParameter("ParentResource");
            this.recordErrorAtParentResource(parentname, startTime, endTime);
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            new CorrelationId();
            String corId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
            if (WMUtils.getLogger().isDebugEnabled()) {
                WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BlamedAndErrorReportingTracer.ITracer_startTrace() Probe Info :" + data.getProbeInformation().getProbeIdentification().getProbeClassName() + " Method Info " + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "CorId:" + corId);
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            WMUtils.getLogger().debug((Throwable)e);
        }
        if (!data.isParameterCallbackInitialized()) {
            data.setParameterCallback((IInvocationDataParameterCallback)this);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String documentType = (String)data.get("DocumentType");
        String documentName = (String)data.get("DocumentName");
        String procRule = (String)data.get("ProcRule");
        if (documentType != null && documentType.length() > 0) {
            parameters.put("DocumentType", documentType);
        }
        if (documentName != null && documentName.length() > 0) {
            parameters.put("DocumentName", documentName);
        }
        if (procRule != null && procRule.length() > 0) {
            parameters.put("ProcRule", procRule);
        }
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        long startTime = data.getWallClockStartTime();
        long endTime = data.getWallClockFinishTime();
        String parentname = this.getParameter("ParentResource");
        Vector lstErrors = (Vector)data.get("listErrors");
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] BlamedAndErrorReportingTracer:: found for document " + data.get("DocumentName") + " list of errors" + lstErrors);
        }
        if (lstErrors != null) {
            int i = 0;
            while (i < lstErrors.size()) {
                String errorMessage = (String)lstErrors.get(i);
                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                ErrorFeature.incrementErrorMetric((IStackElement)data);
                this.recordErrorAtParentResource(parentname, startTime, endTime);
                ++i;
            }
        }
    }

    protected boolean subscribeToDownstreamErrors() {
        return true;
    }

    protected boolean subscribeToDownstreamStalls() {
        return true;
    }
}

