/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.clock.MasterClock;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

public class TNAsyncServiceTracer
extends ASingleInstanceTracerFactory {
    public static final String kMethodNameGetIData = "getIData";
    public static final String kVarBizDoc = "bizdoc";
    public static final String kMethodNameGetTimestamp = "getTimestamp";
    public static final String kMetricSeperator = ":";
    private final AtomicReference<IRepository> fRPIRep = new AtomicReference();
    private final AtomicReference<IRepository> fARTRep = new AtomicReference();

    public TNAsyncServiceTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private Class getClassInstance(String className, InvocationData data) {
        Class<?> clsIData = null;
        try {
            clsIData = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            try {
                clsIData = Class.forName(className);
            }
            catch (Exception exception2) {}
        }
        if (clsIData == null) {
            try {
                clsIData = Class.forName(className, false, data.getInvocationObject().getClass().getClassLoader());
            }
            catch (Exception exception) {}
        }
        return clsIData;
    }

    private Field getServiceField(Object objInvocationObject) throws SecurityException, NoSuchFieldException {
        Field fldService = null;
        try {
            fldService = objInvocationObject.getClass().getDeclaredField("service");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            fldService = objInvocationObject.getClass().getSuperclass().getDeclaredField("service");
        }
        return fldService;
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        try {
            long startTime;
            Object objInvocationObject = data.getInvocationObject();
            Field fldNSService = this.getServiceField(objInvocationObject);
            fldNSService.setAccessible(true);
            Object objNSName = fldNSService.get(objInvocationObject);
            WMUtils.getLogger().debug("START:TNAsyncServiceTracer.ITracer_finishTrace:objNSName:" + objNSName);
            if (objNSName == null || !objNSName.toString().equals("wm.tn.route:invokeWrapper")) {
                WMUtils.getLogger().debug("TNAsyncServiceTracer.Does not match NSName as wm.tn.route:invokeWrapper..Hence return");
                return;
            }
            Timestamp startTimestamp = null;
            Method mthGetIData = objInvocationObject.getClass().getMethod(kMethodNameGetIData, new Class[0]);
            Class<?> clsIData = mthGetIData.getReturnType();
            try {
                Object objOutputData = mthGetIData.invoke(objInvocationObject, new Object[0]);
                Method mtGetValuesEm = null;
                try {
                    Class clsValuesEmulator = this.getClassInstance("com.wm.data.ValuesEmulator", data);
                    mtGetValuesEm = clsValuesEmulator.getMethod("get", clsIData, String.class);
                }
                catch (Exception e) {
                    this.getAgent().IAgent_getModuleFeedback().error((Throwable)e);
                }
                WMUtils.getLogger().debug("END:TNAsyncServiceTracer.ITracer_finishTrace for Finding CorID:");
                Object objBizdocEnvelope = mtGetValuesEm.invoke(null, objOutputData, kVarBizDoc);
                Object objSQLTimestamp = objBizdocEnvelope.getClass().getMethod(kMethodNameGetTimestamp, new Class[0]).invoke(objBizdocEnvelope, new Object[0]);
                startTimestamp = (Timestamp)objSQLTimestamp;
            }
            catch (Exception e) {
                this.getAgent().IAgent_getModuleFeedback().error((Throwable)e);
            }
            long l = startTime = startTimestamp != null ? startTimestamp.getTime() : 0L;
            if (startTime == 0L) {
                Field sessionFld = objInvocationObject.getClass().getDeclaredField("sess");
                sessionFld.setAccessible(true);
                Object session = sessionFld.get(objInvocationObject);
                Field startFld = session.getClass().getDeclaredField("start");
                startFld.setAccessible(true);
                Date startTimeDate = (Date)startFld.get(session);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(startTimeDate);
                startTime = calendar.getTimeInMillis();
            }
            long endTime = MasterClock.currentTimeMillis();
            long responsetime = endTime - startTime;
            this.getAgent().IAgent_getModuleFeedback().debug("TNAsyncServiceTracer.ITracer_finishTrace()responsetime is " + responsetime);
            String componentname = this.formatParameterizedName(data);
            String strRPIMetricname = String.valueOf(componentname) + kMetricSeperator + "Responses Per Interval";
            AgentMetric rpiMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strRPIMetricname, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
            IRepository newRpi = BlamePointTracer.getCountQueuedRepository((boolean)true);
            IRepository prevRpi = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)rpiMetric, (IRepository)newRpi);
            if (prevRpi != null) {
                this.fRPIRep.set(prevRpi);
            } else {
                this.fRPIRep.set(newRpi);
            }
            this.fRPIRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            String strARTMetricname = String.valueOf(componentname) + kMetricSeperator + "Average Response Time (ms)";
            AgentMetric artMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strARTMetricname, 1025, "Invalid Names:Invalid name given for an integer duration metric");
            IRepository newArt = BlamePointTracer.getAverageMetricRepository();
            IRepository prevArt = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)artMetric, (IRepository)newArt);
            if (prevArt != null) {
                this.fARTRep.set(prevArt);
            } else {
                this.fARTRep.set(newArt);
            }
            this.fARTRep.get().update(BlamePointTracer.getUpdater(), responsetime, startTime, endTime);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.getAgent().IAgent_getModuleFeedback().error(e.getMessage());
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

