/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.util;

import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.soaextension.webmethods.util.WMUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WmCache {
    private static final String TN_PROC_RULE_NAME = "procrule";
    private static final String TN_DOCUMENT_TYPE = "docclassname";
    private static final String TN_DOCUMENT_NAME = "doctypename";
    private static final String TN_ACTION_ASYNC = "TN_ACTION_ASYNC";
    private static final String TN_LOG_ACTIVITY_ERRORS = "TN_LOG_ACTIVITY_ERRORS";
    private static final ThreadLocal<Map<String, Object>> cache = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected synchronized Map<String, Object> initialValue() {
            return new ConcurrentHashMap<String, Object>();
        }
    };

    public static void setRule(String val) {
        cache.get().put(WmCache.constructKey(TN_PROC_RULE_NAME), val);
    }

    public static String getRule() {
        return (String)cache.get().get(WmCache.constructKey(TN_PROC_RULE_NAME));
    }

    public static void setDocumentType(String key) {
        cache.get().put(WmCache.constructKey(TN_DOCUMENT_TYPE), key);
    }

    public static String getDocumentType() {
        return (String)cache.get().get(WmCache.constructKey(TN_DOCUMENT_TYPE));
    }

    public static void setDocumentName(String key) {
        cache.get().put(WmCache.constructKey(TN_DOCUMENT_NAME), key);
    }

    public static String getDocumentName() {
        return (String)cache.get().get(WmCache.constructKey(TN_DOCUMENT_NAME));
    }

    public static void setAsyncServiceExec(boolean isAsync) {
        cache.get().put(WmCache.constructKey(TN_ACTION_ASYNC), isAsync);
    }

    public static boolean isAsyncServiceExec() {
        if (cache.get().get(WmCache.constructKey(TN_ACTION_ASYNC)) != null) {
            return (Boolean)cache.get().get(WmCache.constructKey(TN_ACTION_ASYNC));
        }
        return false;
    }

    public static void enableActivityErrorLog(boolean enableActivityErrorLog) {
        cache.get().put(WmCache.constructKey(TN_LOG_ACTIVITY_ERRORS), enableActivityErrorLog);
    }

    public static boolean isActivityErrorLoggingEnabled() {
        if (cache.get().get(WmCache.constructKey(TN_LOG_ACTIVITY_ERRORS)) != null) {
            return (Boolean)cache.get().get(WmCache.constructKey(TN_LOG_ACTIVITY_ERRORS));
        }
        return false;
    }

    private static String constructKey(String tnPropertyName) {
        String corId = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache().getCorrelationID();
        StringBuilder retkey = new StringBuilder(tnPropertyName);
        if (corId != null) {
            retkey.append("##");
            retkey.append(corId);
        }
        if (WMUtils.getLogger().isDebugEnabled()) {
            WMUtils.getLogger().debug("Thread Name [" + Thread.currentThread().getId() + "] Searching for key " + tnPropertyName + " CORID :" + corId + " RETURN VAL " + retkey);
        }
        return retkey.toString();
    }
}

