/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.soaextension.webmethods.KConstants;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class WMUtils {
    private static final Module kWMmodule = new Module("WMAgentExtension");
    public static Boolean fWmClassLoaderLoaded = Boolean.FALSE;
    public static boolean fDebugLogging = false;
    public static boolean fInfoLogging = false;
    public static boolean fWarnLogging = false;
    private static Class fValuesEmulatorCl = null;
    private static Class fIdataClazz = null;
    private static Class fNamespaceClazz = null;
    private static Class fNameClazz = null;
    private static Class fgetInvokeStateClazz = null;
    private static Method fGetMethod = null;
    private static Method fRemoveMethod = null;
    private static Method fGetStringMethod = null;
    private static Method fPutMethod = null;
    private static Method fCreateMethod = null;
    private static Method fGetWSDescriptor = null;
    private static Method fGetTargetNSMethod = null;
    private static Method fFindBinderMethod = null;
    private static Field fModelIdentifierField = null;
    private static Field fSidField = null;
    private static Method fGetModelIdMthd = null;
    private static Field fCtxField = null;
    private static Field fWsdField = null;
    private static Field fSoapActionField = null;
    private static Field fSoapMessageField = null;
    private static Method fGetModelVersionMthd = null;
    private static Field fStateField = null;
    private static Method fGetReqHdrMethod = null;
    private static Method fGetFieldValueMethod = null;
    public static final String kCustomClassloaderJarName = "SOAExtensionForWebMethods_Agent.jar";
    private static final String kLineSeparatorPropertyName = "line.separator";
    private static final String kCorrelationSOAPReadEnabled = "com.wily.introscope.agent.soapheaderread.enabled";
    private static final String kCorrelationSOAPIntertionEnabled = "com.wily.introscope.agent.soapheaderinsertion.enabled";
    private static final String kCorrelationHTTPReadEnabled = "com.wily.introscope.agent.httpheaderread.enabled";
    private static final String kCorrelationHTTPInsertionEnabled = "com.wily.introscope.agent.httpheaderinsertion.enabled";
    private static final String kStepDispatcherAgent_contextFieldName = "ctx";
    private static final String kStepIdFieldName = "sid";
    private static ProtectedLogger sLogger = new ProtectedLogger(null, null);

    private WMUtils() {
    }

    public static final Module getModule() {
        return kWMmodule;
    }

    public static IModuleFeedbackChannel getLogger() {
        return sLogger;
    }

    public static Object invokeMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = clazz.getMethod(methodName, parameterTypes);
        return method.invoke(object, args);
    }

    public static Object invokeMethodOnObject(Object object, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WMUtils.invokeMethodOnObject(object, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeDeclaredMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
        return method.invoke(object, args);
    }

    public static Object invokeDeclaredMethodOnObject(Object object, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WMUtils.invokeDeclaredMethodOnObject(object, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WMUtils.invokeMethodOnClass(clazz, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getMethod(methodName, parameterTypes);
        return method.invoke(null, args);
    }

    public static Method findGetPropertyWithStringArgMethod(Class clazz) throws NoSuchMethodException, SecurityException {
        return clazz.getMethod("getProperty", KConstants.kSingleStringClassArray);
    }

    public static Method find_GetPropertyWithStringArgMethod(Class clazz) throws NoSuchMethodException, SecurityException {
        return clazz.getMethod("_getProperty", KConstants.kSingleStringClassArray);
    }

    public static String toString(Object object) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (String)WMUtils.invokeMethodOnObject(object, "toString");
    }

    public static Method getMethodForObject(Object object, String methodName, Class[] paramTypes) throws NoSuchMethodException, SecurityException, IllegalArgumentException {
        Class<?> clazz = object.getClass();
        return clazz.getMethod(methodName, paramTypes);
    }

    public static Object getField(Object object, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        return field.get(object);
    }

    public static String resource2URI(String resource) {
        int index;
        if (resource != null && (index = resource.indexOf(95)) != -1) {
            StringBuffer buf = new StringBuffer(resource);
            buf.setCharAt(index, ':');
            resource = buf.toString();
        }
        return resource;
    }

    public static String URI2Resource(String URI2) {
        int index;
        if (URI2 != null && (index = URI2.indexOf(58)) != -1) {
            StringBuffer buf = new StringBuffer(URI2);
            buf.setCharAt(index, '_');
            URI2 = buf.toString();
        }
        return URI2;
    }

    public static String convertToServiceNode(String fullyQualifiedName) {
        return StringUtils.replace((String)fullyQualifiedName, (String)":", (String)"|");
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])KConstants.kIllegalResourceChars, (char)'_');
    }

    public static String formatURLToBeResourceSafe(String URL2) {
        String newURL = null;
        StringBuffer newURLBuffer = new StringBuffer();
        String substituteString = null;
        if (URL2 != null) {
            try {
                substituteString = WMUtils.getAgent().IAgent_getIndexedProperties().getProperty("com.wily.introscope.agent.soa.metricNameFormatting");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            if (substituteString == null) {
                return URL2;
            }
            StringTokenizer strTok = new StringTokenizer(URL2, substituteString);
            int tokens = strTok.countTokens();
            int x = 0;
            while (x < tokens) {
                String token = strTok.nextToken();
                if (!token.equals("")) {
                    newURLBuffer.append(token).append("_");
                }
                ++x;
            }
            if (newURLBuffer.length() < 2) {
                newURL = null;
            } else {
                String tempURL = newURLBuffer.toString();
                newURL = tempURL.trim().substring(0, tempURL.length() - 1);
            }
        }
        return newURL;
    }

    public static String formatSOAPFaultURLToBeResourceSafe(String URL2) {
        String newURL = null;
        StringBuffer newURLBuffer = new StringBuffer();
        String substituteString = null;
        if (URL2 != null) {
            try {
                substituteString = WMUtils.getAgent().IAgent_getIndexedProperties().getProperty("com.wily.introscope.agent.soa.metricNameFormatting");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            substituteString = substituteString != null ? String.valueOf(substituteString) + ":@=&$-+!*'()," : ":@=&$-+!*'(),";
            StringTokenizer strTok = new StringTokenizer(URL2, substituteString);
            int tokens = strTok.countTokens();
            int x = 0;
            while (x < tokens) {
                String token = strTok.nextToken();
                if (!token.equals("")) {
                    newURLBuffer.append(token).append("_");
                }
                ++x;
            }
            if (newURLBuffer.length() < 2) {
                newURL = null;
            } else {
                String tempURL = newURLBuffer.toString();
                newURL = tempURL.trim().substring(0, tempURL.length() - 1);
            }
        }
        return newURL;
    }

    public static void handleError(IAgent agent, String localizedKey, Throwable t) {
        if (agent.IAgent_getModuleFeedback().isVerboseEnabled()) {
            agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey), t);
        } else {
            agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
        }
    }

    public static void handleError(IAgent agent, String localizedKey) {
        agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
    }

    public static void handleError(String localizedKey, Throwable t) {
        try {
            IAgent agent = WMUtils.getAgent();
            if (agent.IAgent_getModuleFeedback().isVerboseEnabled()) {
                agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey), t);
            } else {
                agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
            }
        }
        catch (AgentNotAvailableException ae) {
            WMUtils.getLogger().debug("Exception in handling error:" + ae.getMessage());
        }
    }

    public static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgent();
    }

    public static IModuleFeedbackChannel getAgentLogger() throws AgentNotAvailableException {
        return WMUtils.getAgent().IAgent_getModuleFeedback();
    }

    public static IStringLocalizer getAgentStringLocalizer() throws AgentNotAvailableException {
        return WMUtils.getAgent().IAgent_getStringLocalizer();
    }

    public static IndexedProperties getAgentConfiguration() throws AgentNotAvailableException {
        return WMUtils.getAgent().IAgent_getIndexedProperties();
    }

    public static void getKeyAndValue(String context, StringBuffer key, StringBuffer value) {
        WMUtils.refreshLogLevels();
        WMUtils.getLogger().debug("getKeyAndValue");
        int equals = context.indexOf("=");
        if (equals != -1) {
            key.append(context.substring(0, equals));
            value.append(context.substring(equals + 1));
            WMUtils.getLogger().debug("getKeyAndValue key=" + key + " value= " + value);
        }
    }

    public static void refreshLogLevels() {
        fDebugLogging = sLogger.isDebugEnabled();
        fInfoLogging = sLogger.isInfoEnabled(WMUtils.getModule());
        fWarnLogging = sLogger.isWarningEnabled(WMUtils.getModule());
    }

    public static boolean isDebugLogging() {
        return fDebugLogging;
    }

    public static boolean isInfoLogging() {
        return fInfoLogging;
    }

    public static boolean isWarnLogging() {
        return fWarnLogging;
    }

    public static String dumpStackTrace(Throwable bomb) {
        StackTracePrintStream stack = new StackTracePrintStream((OutputStream)new ByteArrayOutputStream(), 1024);
        bomb.printStackTrace(stack);
        return stack.getString();
    }

    public static IResource getDirFinder(String directoryName, String fileName) {
        ExtendedFile wilyDirectory = new ExtendedFile(directoryName);
        String fullPath = new ExtendedFile(wilyDirectory, fileName).safeGetCanonicalPath();
        return new FileBasedResource(fullPath);
    }

    public static String getAbsoluteAgentPath() {
        String path = "";
        try {
            IResource profileResource = WMUtils.getAgent().IAgent_getConfigurationResource();
            if (profileResource.IResource_isFileResource()) {
                File profileDirectory = new File(profileResource.IResource_getLocation()).getParentFile();
                File pathFile = new File(profileDirectory, path);
                path = pathFile.getAbsolutePath();
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            path = "wily";
        }
        return path;
    }

    public static String getExtensionDirectory() {
        String extFolder = "";
        try {
            IndexedProperties props = WMUtils.getAgentConfiguration();
            extFolder = props.getTrimmedProperty("introscope.agent.extensions.directory");
        }
        catch (AgentNotAvailableException bomb) {
            WMUtils.getLogger().error("getExtensionDirectory " + WMUtils.dumpStackTrace(bomb));
        }
        return extFolder;
    }

    public static boolean correlationSOAPInsertionEnabled() {
        try {
            IAgent agent = WMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kCorrelationSOAPIntertionEnabled, true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean correlationSOAPReadEnabled() {
        try {
            IAgent agent = WMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kCorrelationSOAPReadEnabled, true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean correlationHTTPInsertionEnabled() {
        try {
            IAgent agent = WMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kCorrelationHTTPInsertionEnabled, true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean correlationHTTPReadEnabled() {
        try {
            IAgent agent = WMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kCorrelationHTTPReadEnabled, true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static Class getValuesEmulatorClass() throws ClassNotFoundException {
        if (fValuesEmulatorCl == null) {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            fValuesEmulatorCl = Class.forName(KConstants.kVALUESEMULATOR, false, threadClassLoader);
        }
        return fValuesEmulatorCl;
    }

    public static Class getIDataClass() throws ClassNotFoundException {
        if (fIdataClazz == null) {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            fIdataClazz = Class.forName(KConstants.kIDATA, false, threadClassLoader);
        }
        return fIdataClazz;
    }

    public static Object invokeGet(Class clazz, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (fGetMethod == null) {
            fGetMethod = clazz.getMethod("get", parameterTypes);
            fGetMethod.setAccessible(true);
        }
        return fGetMethod.invoke(null, args);
    }

    public static Object invokeGetOnValuesEmulator(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fGetMethod == null) {
            Class[] parameterTypes = new Class[]{WMUtils.getIDataClass(), String.class};
            fGetMethod = WMUtils.getValuesEmulatorClass().getMethod("get", parameterTypes);
            fGetMethod.setAccessible(true);
        }
        return fGetMethod.invoke(null, args);
    }

    public static Object invokeRemove(Class clazz, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (fRemoveMethod == null) {
            fRemoveMethod = clazz.getMethod("remove", parameterTypes);
            fRemoveMethod.setAccessible(true);
        }
        return fRemoveMethod.invoke(null, args);
    }

    public static Object invokeRemoveOnValuesEmulator(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fRemoveMethod == null) {
            Class[] parameterTypes = new Class[]{WMUtils.getIDataClass(), String.class};
            fRemoveMethod = WMUtils.getValuesEmulatorClass().getMethod("remove", parameterTypes);
            fRemoveMethod.setAccessible(true);
        }
        return fRemoveMethod.invoke(null, args);
    }

    public static Object invokePut(Class clazz, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (fPutMethod == null) {
            fPutMethod = clazz.getMethod("put", parameterTypes);
            fPutMethod.setAccessible(true);
        }
        return fPutMethod.invoke(null, args);
    }

    public static Object invokePutOnValuesEmulator(Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, SecurityException, ClassNotFoundException {
        if (fPutMethod == null) {
            fPutMethod = WMUtils.getValuesEmulatorClass().getMethod("put", parameterTypes);
            fPutMethod.setAccessible(true);
        }
        return fPutMethod.invoke(null, args);
    }

    public static String invokeGetString(Class clazz, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (fGetStringMethod == null) {
            fGetStringMethod = clazz.getMethod("getString", parameterTypes);
            fGetStringMethod.setAccessible(true);
        }
        return (String)fGetStringMethod.invoke(null, args);
    }

    public static String invokeGetStringOnValuesEmulator(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fGetStringMethod == null) {
            Class[] parameterTypes = new Class[]{WMUtils.getIDataClass(), String.class};
            fGetStringMethod = WMUtils.getValuesEmulatorClass().getMethod("getString", parameterTypes);
            fGetStringMethod.setAccessible(true);
        }
        return (String)fGetStringMethod.invoke(null, args);
    }

    public static Class getNamespaceClass() throws ClassNotFoundException {
        if (fNamespaceClazz == null) {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            fNamespaceClazz = Class.forName(KConstants.kNAMESPACE, false, threadClassLoader);
        }
        return fNamespaceClazz;
    }

    public static Class getNameClass() throws ClassNotFoundException {
        if (fNameClazz == null) {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            fNameClazz = Class.forName(KConstants.kNAME, false, threadClassLoader);
        }
        return fNameClazz;
    }

    public static Class getInvokeStateClass() throws ClassNotFoundException {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        fgetInvokeStateClazz = Class.forName("com.wm.app.b2b.server.InvokeState", false, threadClassLoader);
        return fgetInvokeStateClazz;
    }

    public static String getWsdNameForVersion8x() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String wsdName = "";
        Class invokeStateClazz = WMUtils.getInvokeStateClass();
        Object invokeState = WMUtils.invokeMethodOnClass(invokeStateClazz, "getCurrentState");
        Object callStack = WMUtils.invokeMethodOnObject(invokeState, "getCallStack");
        Integer size = (Integer)WMUtils.invokeMethodOnObject(callStack, "size");
        if (size >= 2) {
            Object connectorFlow = WMUtils.invokeMethodOnObject(callStack, "get", new Class[]{Integer.TYPE}, new Object[]{size - 2});
            Object wsdNameObject = WMUtils.invokeMethodOnObject(connectorFlow, "getParentWSD");
            wsdName = (String)wsdNameObject;
        }
        return wsdName;
    }

    public static Object invokeCreateOnName(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fCreateMethod == null) {
            Class[] parameterTypes = new Class[]{String.class};
            fCreateMethod = WMUtils.getNameClass().getMethod("create", parameterTypes);
            fCreateMethod.setAccessible(true);
        }
        return fCreateMethod.invoke(null, args);
    }

    public static Object invokeGetWSDescOnNamespace(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fGetWSDescriptor == null) {
            Class[] parameterTypes = new Class[]{WMUtils.getNameClass()};
            fGetWSDescriptor = WMUtils.getNamespaceClass().getMethod("getWebServiceDescriptor", parameterTypes);
            fGetWSDescriptor.setAccessible(true);
        }
        return fGetWSDescriptor.invoke(null, args);
    }

    public static Method getTargetNSonWSD(Object wsdObj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fGetTargetNSMethod == null || !fGetTargetNSMethod.getDeclaringClass().equals(wsdObj.getClass())) {
            fGetTargetNSMethod = wsdObj.getClass().getMethod("getTargetNamespace", new Class[0]);
            fGetTargetNSMethod.setAccessible(true);
        }
        return fGetTargetNSMethod;
    }

    public static Method getFindBinderonWSD(Object wsdObj, Class[] clArr) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fFindBinderMethod == null || !fFindBinderMethod.getDeclaringClass().equals(wsdObj.getClass())) {
            fFindBinderMethod = wsdObj.getClass().getMethod("findBinder", clArr);
            fFindBinderMethod.setAccessible(true);
        }
        return fFindBinderMethod;
    }

    public static Field getmodelIdentifierFld(Object sdaObj) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fModelIdentifierField == null) {
            fModelIdentifierField = sdaObj.getClass().getDeclaredField("modelIdentifier");
            fModelIdentifierField.setAccessible(true);
        }
        return fModelIdentifierField;
    }

    public static Method getModelIdMethod(Object modelIdObj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fGetModelIdMthd == null) {
            fGetModelIdMthd = modelIdObj.getClass().getMethod("getModelId", new Class[0]);
            fGetModelIdMthd.setAccessible(true);
        }
        return fGetModelIdMthd;
    }

    public static Method getModelVersionMethod(Object modelIdObj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fGetModelVersionMthd == null) {
            fGetModelVersionMthd = modelIdObj.getClass().getMethod("getModelVersion", new Class[0]);
            fGetModelVersionMthd.setAccessible(true);
        }
        return fGetModelVersionMthd;
    }

    public static Field getSIDFld(Object sdaObj) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (fSidField == null) {
            fSidField = sdaObj.getClass().getDeclaredField(kStepIdFieldName);
            fSidField.setAccessible(true);
        }
        return fSidField;
    }

    public static String getSID(Object stepDispatcherAgentObject) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String sid = null;
        fCtxField = stepDispatcherAgentObject.getClass().getDeclaredField(kStepDispatcherAgent_contextFieldName);
        fCtxField.setAccessible(true);
        Object ctxObject = fCtxField.get(stepDispatcherAgentObject);
        fSidField = ctxObject.getClass().getDeclaredField(kStepIdFieldName);
        fSidField.setAccessible(true);
        sid = (String)fSidField.get(ctxObject);
        return sid;
    }

    public static Field getWsdField(Object wsImplObject) throws NoSuchFieldException, IllegalAccessException {
        if (fWsdField == null) {
            fWsdField = wsImplObject.getClass().getDeclaredField("wsd");
            fWsdField.setAccessible(true);
        }
        return fWsdField;
    }

    public static Field getSoapActionField(Object wsImplObject) throws NoSuchFieldException, IllegalAccessException {
        if (fSoapActionField == null) {
            fSoapActionField = wsImplObject.getClass().getDeclaredField("soapaction");
            fSoapActionField.setAccessible(true);
        }
        return fSoapActionField;
    }

    public static Field getSoapMessageField(Object wsImplObject) throws SecurityException, NoSuchFieldException {
        if (fSoapMessageField == null) {
            fSoapMessageField = wsImplObject.getClass().getDeclaredField("responseMsg");
            fSoapMessageField.setAccessible(true);
        }
        return fSoapMessageField;
    }

    public static boolean getIsSubEnd(Object sdaObj) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Field ctxField = sdaObj.getClass().getDeclaredField(kStepDispatcherAgent_contextFieldName);
        ctxField.setAccessible(true);
        Object ctxObject = ctxField.get(sdaObj);
        Field stepDefField = ctxObject.getClass().getDeclaredField("stepDef");
        stepDefField.setAccessible(true);
        Object stepDefObject = stepDefField.get(ctxObject);
        Method getMhd = stepDefObject.getClass().getMethod("isSubEnd", new Class[0]);
        boolean isSubEnd = false;
        isSubEnd = (Boolean)getMhd.invoke(stepDefObject, new Object[0]);
        return isSubEnd;
    }

    public static String getSoapActionFromProtocolState(Object wsImplObject) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String soapaction_1_1;
        if (fStateField == null) {
            fStateField = wsImplObject.getClass().getDeclaredField("state");
            fStateField.setAccessible(true);
        }
        Object state = fStateField.get(wsImplObject);
        if (fGetReqHdrMethod == null) {
            fGetReqHdrMethod = state.getClass().getMethod("getReqHdr", new Class[0]);
            fGetReqHdrMethod.setAccessible(true);
        }
        Object reqHdr = fGetReqHdrMethod.invoke(state, new Object[0]);
        if (fGetFieldValueMethod == null) {
            fGetFieldValueMethod = reqHdr.getClass().getMethod("getFieldValue", String.class);
            fGetFieldValueMethod.setAccessible(true);
        }
        if ((soapaction_1_1 = (String)fGetFieldValueMethod.invoke(reqHdr, "soapAction")) != null) {
            soapaction_1_1 = WMUtils.trimSoapAction(soapaction_1_1);
        }
        return soapaction_1_1;
    }

    public static String trimSoapAction(String soapaction) {
        return soapaction.substring(1, soapaction.length() - 1);
    }

    public static String getConfigFilePath() {
        String path = "";
        try {
            IResource resource;
            IndexedProperties props = AgentShim.getAgent().IAgent_getIndexedProperties();
            path = props.getProperty("introscope.agent.common.directory");
            if (!ExtendedFile.isAbsolutePath((String)path) && (resource = AgentShim.getAgent().IAgent_getConfigurationResource()) != null && resource.IResource_isFileResource()) {
                path = String.valueOf(new File(resource.IResource_getLocation()).getParent()) + "/" + path;
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        WMUtils.getLogger().debug("The location of wmExtension.config is " + path);
        return path;
    }

    private static class ProtectedLogger
    implements IModuleFeedbackChannel {
        private synchronized IModuleFeedbackChannel getFeedbackChannel() {
            IModuleFeedbackChannel channel = null;
            try {
                channel = WMUtils.getAgentLogger();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            return channel;
        }

        public boolean isVerboseEnabled() {
            boolean verbose = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                verbose = channel.isVerboseEnabled(WMUtils.getModule());
            }
            return verbose;
        }

        public boolean isDebugEnabled() {
            boolean debug = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                debug = channel.isDebugEnabled(WMUtils.getModule());
            }
            return debug;
        }

        public boolean isTraceEnabled() {
            boolean trace = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                trace = channel.isTraceEnabled(WMUtils.getModule());
            }
            return trace;
        }

        public boolean isErrorEnabled(Module module) {
            boolean error = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                error = channel.isErrorEnabled(module);
            }
            return error;
        }

        public boolean isWarningEnabled(Module module) {
            boolean warn = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                warn = channel.isWarningEnabled(module);
            }
            return warn;
        }

        public boolean isInfoEnabled(Module module) {
            boolean info = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                info = channel.isInfoEnabled(module);
            }
            return info;
        }

        public boolean isVerboseEnabled(Module module) {
            boolean verbose = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                verbose = channel.isVerboseEnabled(module);
            }
            return verbose;
        }

        public boolean isDebugEnabled(Module module) {
            boolean debug = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                debug = channel.isDebugEnabled(module);
            }
            return debug;
        }

        public boolean isTraceEnabled(Module module) {
            boolean trace = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                trace = channel.isTraceEnabled(module);
            }
            return trace;
        }

        public boolean isLogEnabled(SeverityLevel severityLevel, Module module) {
            boolean log = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                log = channel.isLogEnabled(severityLevel, module);
            }
            return log;
        }

        public void error(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(WMUtils.getModule(), string);
            }
        }

        public void error(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(WMUtils.getModule(), string, throwable);
            }
        }

        public void warn(String string) {
            IModuleFeedbackChannel channel;
            if (fWarnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(WMUtils.getModule(), string);
            }
        }

        public void warn(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (fWarnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(WMUtils.getModule(), string, throwable);
            }
        }

        public void info(String string) {
            IModuleFeedbackChannel channel;
            if (fInfoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(WMUtils.getModule(), string);
            }
        }

        public void info(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (fInfoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(WMUtils.getModule(), string, throwable);
            }
        }

        public void verbose(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(WMUtils.getModule(), string);
            }
        }

        public void verbose(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(WMUtils.getModule(), string, throwable);
            }
        }

        public void debug(String string) {
            IModuleFeedbackChannel channel;
            if (fDebugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(WMUtils.getModule(), string);
            }
        }

        public void debug(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (fDebugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(WMUtils.getModule(), string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, WMUtils.getModule(), string);
            }
        }

        public void log(SeverityLevel severityLevel, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, WMUtils.getModule(), string, throwable);
            }
        }

        public void error(Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(WMUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void verbose(Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(WMUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void debug(Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (fDebugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(WMUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void error(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(module, string);
            }
        }

        public void error(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(module, string, throwable);
            }
        }

        public void warn(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (fWarnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(module, string);
            }
        }

        public void warn(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (fWarnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(module, string, throwable);
            }
        }

        public void info(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (fInfoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(module, string);
            }
        }

        public void info(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (fInfoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(module, string, throwable);
            }
        }

        public void verbose(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(module, string);
            }
        }

        public void verbose(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(module, string, throwable);
            }
        }

        public void debug(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (fDebugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(module, string);
            }
        }

        public void debug(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (fDebugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(module, string, throwable);
            }
        }

        public void trace(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(WMUtils.getModule(), string);
            }
        }

        public void trace(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(WMUtils.getModule(), string, throwable);
            }
        }

        public void trace(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(module, string);
            }
        }

        public void trace(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(module, string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, module, string);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, module, string, throwable);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.logImmediate(severityLevel, module, string);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.logImmediate(severityLevel, module, string, throwable);
            }
        }

        public void setLevel(SeverityLevel level, Module module) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.setLevel(level, module);
            }
        }

        public SeverityLevel getLevel(Module module) {
            SeverityLevel level = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                level = channel.getLevel(module);
            }
            return level;
        }

        public SeverityLevel getEffectiveLevel(Module module) {
            SeverityLevel level = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                level = channel.getEffectiveLevel(module);
            }
            return level;
        }

        public String getApplicationName() {
            String appName = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                appName = channel.getApplicationName();
            }
            return appName;
        }

        public String getModuleName() {
            String name = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                name = channel.getModuleName();
            }
            return name;
        }

        private ProtectedLogger() {
        }

        ProtectedLogger(ProtectedLogger protectedlogger) {
            this();
        }

        /* synthetic */ ProtectedLogger(ProtectedLogger protectedLogger, ProtectedLogger protectedLogger2) {
            this();
        }
    }

    private static class StackTracePrintStream
    extends PrintStream {
        private final char[] fLineSeparator = System.getProperty("line.separator").toCharArray();
        private int fCursor = 0;
        private char[] fChars;
        private int fCharCount;

        public StackTracePrintStream(OutputStream dummy, int initialSize) {
            super(dummy);
            this.fChars = new char[initialSize];
            this.fCharCount = initialSize;
        }

        @Override
        public synchronized void print(char[] data) {
            while (this.fCursor + data.length > this.fCharCount) {
                this.growBuffer();
            }
            System.arraycopy(data, 0, this.fChars, this.fCursor, data.length);
            this.fCursor += data.length;
        }

        @Override
        public synchronized void print(String s) {
            if (s == null) {
                s = "null";
            }
            int length = s.length();
            while (this.fCursor + length > this.fCharCount) {
                this.growBuffer();
            }
            s.getChars(0, length, this.fChars, this.fCursor);
            this.fCursor += length;
        }

        @Override
        public synchronized void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        @Override
        public synchronized void println(char[] data) {
            this.print(data);
            this.printSeparator();
        }

        @Override
        public synchronized void println(String s) {
            this.print(s);
            this.printSeparator();
        }

        @Override
        public synchronized void println(Object obj) {
            this.print(obj);
            this.printSeparator();
        }

        @Override
        public synchronized void println() {
            this.printSeparator();
        }

        private void printSeparator() {
            this.print(this.fLineSeparator);
        }

        private void growBuffer() {
            int newSize = this.fCharCount * 2;
            char[] newBuffer = new char[newSize];
            System.arraycopy(this.fChars, 0, newBuffer, 0, this.fCharCount);
            this.fCharCount = newSize;
            this.fChars = newBuffer;
        }

        public String getString() {
            return new String(this.fChars, 0, this.fCursor);
        }

        public void reset() {
            this.fCursor = 0;
        }

        @Override
        public void flush() {
        }
    }
}

