/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WebServicesFaultReportingTracer
extends ASingleMetricTracerFactory {
    public WebServicesFaultReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            Object isBinderNotNull = data.get("isBinderNotNull");
            if (isBinderNotNull != null && ((Boolean)isBinderNotNull).booleanValue()) {
                boolean hasFault = false;
                if (data.get("hasFault") != null) {
                    hasFault = (Boolean)data.get("hasFault");
                }
                if (hasFault) {
                    String errorMessage = (String)data.get("faultMessage");
                    boolean recordFault = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage);
                    if (recordFault) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    }
                    String name = this.formatParameterizedName(data);
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
            }
        }
        catch (ESEException e) {
            Assertion.wilyFail((String)("Metric type conflict" + e.getMessage()));
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + bomb.getMessage());
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            Object wsdObj = data.getInvocationParameterAsObject(3);
            String soapactionObj = (String)data.getInvocationParameterAsObject(6);
            if (wsdObj != null && soapactionObj != null) {
                Object binderObj = null;
                Class[] clArr = new Class[]{String.class};
                Object[] obArr = new Object[]{soapactionObj};
                Method binderMth = WMUtils.getFindBinderonWSD(wsdObj, clArr);
                binderObj = binderMth.invoke(wsdObj, obArr);
                if (binderObj != null) {
                    data.put("isBinderNotNull", (Object)true);
                    Object soapMsg = data.getInvocationParameterAsObject(10);
                    this.processComponent(data, wsdObj, soapactionObj, soapMsg);
                } else {
                    data.put("isBinderNotNull", (Object)false);
                }
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + bomb.getMessage());
        }
    }

    protected void processComponent(InvocationData data, Object wsdObj, Object soapactionObj, Object soapMsg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object soapBody = WMUtils.invokeMethodOnObject(soapMsg, "getSOAPBody");
        boolean hasFault = (Boolean)WMUtils.invokeMethodOnObject(soapBody, "hasFault");
        data.put("hasFault", (Object)hasFault);
        String component = this.formatParameterizedResource(data);
        if (hasFault) {
            Object detailObj;
            String errorMessage = null;
            String faulttext = null;
            Object faultObj = WMUtils.invokeMethodOnObject(soapBody, "getFault");
            faulttext = (String)WMUtils.invokeMethodOnObject(faultObj, "getFaultString");
            if (faulttext == null && (detailObj = WMUtils.invokeMethodOnObject(faultObj, "getDetail")) != null) {
                faulttext = ((String)WMUtils.invokeMethodOnObject(detailObj, "getText")).trim();
                WMUtils.getLogger().debug("WSFaultTracer::Got fault detail as:" + faulttext);
            }
            errorMessage = faulttext != null ? (!faulttext.equals("") ? "SOAP Fault:" + faulttext : "SOAP Fault:" + component + ":" + "SOAP Fault occured") : "SOAP Fault:" + component + ":" + "SOAP Fault occured";
            data.put("faultMessage", (Object)errorMessage);
        }
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }
}

