/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.FaultedBlameTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class WebServicesFaultReportingTracer
extends BlamePointTracer {
    public WebServicesFaultReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            Object isBinderNotNull = data.get("isBinderNotNull");
            if (isBinderNotNull != null && ((Boolean)isBinderNotNull).booleanValue()) {
                super.ITracer_finishTrace(index, data);
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + bomb.getMessage());
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        Object wsdObj = data.getInvocationParameterAsObject(3);
        String soapactionObj = (String)data.getInvocationParameterAsObject(6);
        Object binderObj = null;
        Object soapMsg = null;
        try {
            if (wsdObj != null && soapactionObj != null) {
                Class[] clArr = new Class[]{String.class};
                Object[] obArr = new Object[]{soapactionObj};
                Method binderMth = WMUtils.getFindBinderonWSD(wsdObj, clArr);
                binderObj = binderMth.invoke(wsdObj, obArr);
            }
            if (binderObj != null) {
                soapMsg = data.getInvocationParameterAsObject(10);
                data.put("isBinderNotNull", (Object)true);
            } else {
                data.put("isBinderNotNull", (Object)false);
            }
            this.processComponent(index, data, wsdObj, soapactionObj, soapMsg);
            if (binderObj != null) {
                super.doStartBlamePointTrace(index, data);
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + bomb.getMessage());
        }
    }

    protected void processComponent(int index, InvocationData data, Object wsdObj, Object soapactionObj, Object soapMsg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object soapBody;
        boolean hasFault = false;
        if (soapMsg != null && (soapBody = WMUtils.invokeMethodOnObject(soapMsg, "getSOAPBody")) != null) {
            hasFault = (Boolean)WMUtils.invokeMethodOnObject(soapBody, "hasFault");
            data.put("hasFault", (Object)hasFault);
            String component = data.getComponentNameAt(index);
            if (hasFault) {
                Object detailObj;
                String faultMessage = null;
                String faulttext = null;
                Object faultObj = WMUtils.invokeMethodOnObject(soapBody, "getFault");
                faulttext = (String)WMUtils.invokeMethodOnObject(faultObj, "getFaultString");
                if (faulttext == null && (detailObj = WMUtils.invokeMethodOnObject(faultObj, "getDetail")) != null) {
                    faulttext = ((String)WMUtils.invokeMethodOnObject(detailObj, "getText")).trim();
                    WMUtils.getLogger().debug("WSFaultTracer::Got fault detail as:" + faulttext);
                }
                faultMessage = faulttext != null ? (!faulttext.equals("") ? "SOAP Fault:" + faulttext : "SOAP Fault:" + component + ":" + "SOAP Fault occured") : "SOAP Fault:" + component + ":" + "SOAP Fault occured";
                data.put("faultMessage", (Object)faultMessage);
            }
        }
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        boolean hasFault = false;
        if (data.get("hasFault") != null) {
            hasFault = (Boolean)data.get("hasFault");
        }
        if (hasFault) {
            try {
                String faultMessage = (String)data.get("faultMessage");
                if (faultMessage != null) {
                    FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)faultMessage, (IAgent)this.getAgent());
                    FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)faultMessage);
                }
                FaultFeature.incrementFaultMetric((InvocationData)data);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
                WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
            }
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        HashMap metrics = new HashMap(1);
        AgentMetric[] faultMetric = this.createErrorsMetric(FaultFeature.getFaultsMetricName((String)metricName));
        FaultedBlameTransactionElement result = FaultFeature.createFaultedBlameTransactionElement((Object)key, (String)metricName, (int)blameStatus, (boolean)isStartTrace, (ITransactionElement)parent, (IBlameTransactionElement)previous, (IBlameTransactionElement)start, metrics, null, null, null, null, null, (ProbeInformation)probeInformation, (AgentMetric[])faultMetric, (boolean)true, (boolean)true, (boolean)true);
        return result;
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setStartCursorAt(element, tracerIndex);
    }

    public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }

    public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }
}

