/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Iterator;
import java.util.List;

public class DataTransferUtils {
    private DataTransferUtils() {
    }

    public static boolean dataFlavorsEqual(DataFlavor target, DataFlavor source) {
        String targetRealType = DataTransferUtils.getWilyRealType(target);
        String sourceRealType = DataTransferUtils.getWilyRealType(source);
        if (targetRealType != null) {
            return target.equals(source) && targetRealType.equals(sourceRealType);
        }
        return sourceRealType == null;
    }

    public static boolean interestedInAllDataFlavors(List dataFlavorArraysList, DataFlavor[] interestingDataFlavors) {
        Iterator iterator = dataFlavorArraysList.iterator();
        while (iterator.hasNext()) {
            DataFlavor[] dfArray = (DataFlavor[])iterator.next();
            for (int i = 0; i < dfArray.length; ++i) {
                DataFlavor df = dfArray[i];
                for (int j = 0; j < interestingDataFlavors.length; ++j) {
                    DataFlavor interestingDf = interestingDataFlavors[j];
                    if (DataTransferUtils.dataFlavorsEqual(df, interestingDf)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static String getWilyRealType(DataFlavor df) {
        return df.getParameter("x-wily-realtype");
    }

    public static Object getTransferData(Transferable transferable, DataFlavor[] dataFlavors) {
        Object transferData = null;
        for (int i = 0; i < dataFlavors.length && transferData == null; ++i) {
            try {
                transferData = transferable.getTransferData(dataFlavors[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return transferData;
    }

    public static Object getTransferData(Transferable transferable, DataFlavor dataFlavor) {
        return DataTransferUtils.getTransferData(transferable, new DataFlavor[]{dataFlavor});
    }
}

