/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.widget;

import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.ThresholdValue;
import com.wily.ui.widget.IWidget;
import com.wily.util.Range;
import com.wily.util.Scale;
import com.wily.wilyassert.Assertion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AContinuousValueDisplayWidget
implements KWilyUserInterfaceConstants,
IWidget {
    private double fHoleValue;
    protected Scale fScale;
    protected ThresholdValue fThreshold;
    protected double fCurrentValue;

    private AContinuousValueDisplayWidget() {
    }

    public AContinuousValueDisplayWidget(double holeValue) {
        this(holeValue, new Scale());
    }

    public AContinuousValueDisplayWidget(double holeValue, Scale scale) {
        this(holeValue, scale, null);
    }

    public AContinuousValueDisplayWidget(double holeValue, Scale scale, ThresholdValue threshold) {
        this.setHoleValue(holeValue);
        this.setScale(scale);
        this.fThreshold = threshold;
    }

    public abstract void draw(Graphics var1, Dimension var2);

    public synchronized void setCurrentValue(double currentValue) {
        this.fCurrentValue = currentValue;
    }

    protected synchronized double getCurrentValue() {
        return this.fCurrentValue;
    }

    public synchronized void expandRange(double value) {
        this.fScale.expandScale(value);
    }

    public synchronized void collapseRange(Range range) {
        this.fScale.collapseScale(range);
    }

    private void setHoleValue(double holeValue) {
        this.fHoleValue = holeValue;
    }

    protected double getHoleValue() {
        return this.fHoleValue;
    }

    protected boolean currentValueIsHoleValue() {
        return this.getCurrentValue() == this.getHoleValue();
    }

    public synchronized void setScale(Scale newScale) {
        this.fScale = newScale;
    }

    public synchronized Scale getScale() {
        return this.fScale;
    }

    public ThresholdValue getThresholdValue() {
        return this.fThreshold;
    }

    protected boolean hasThreshold() {
        return this.fThreshold != null;
    }

    private Style getDefaultRangeStyle() {
        return new Style(kSharedEmptyColor, false);
    }

    private Style getNoThresholdRangeStyle() {
        return new Style(kSharedNeutralColor, true);
    }

    private Style getBelowThresholdStyle() {
        return new Style(kSharedUnderThresholdColor, true);
    }

    private Style getWarningThresholdExceededStyle() {
        return new Style(kSharedWarningThresholdColor, true);
    }

    private Style getDangerThresholdExceededStyle() {
        return new Style(kSharedDangerThresholdColor, true);
    }

    protected RangeStyles getRangeStyles(ThresholdValue thresholdValue, double currentValue) {
        RangeStyles rangeStyles = thresholdValue == null ? this.computeNoThresholdRangeStyles(currentValue) : (thresholdValue.hasCaution() ? this.computeFullThresholdRangeStyles(thresholdValue, currentValue) : this.computePartialThresholdRangeStyles(thresholdValue, currentValue));
        return rangeStyles;
    }

    private RangeStyles computeNoThresholdRangeStyles(double currentValue) {
        RangeStyles rangeStyles = new RangeStyles(this.getDefaultRangeStyle());
        Range currentValueRange = new Range(0.0, currentValue);
        rangeStyles.addRangeStyle(currentValueRange, this.getNoThresholdRangeStyle());
        rangeStyles.setOrigin(0.0);
        rangeStyles.setCurrentValue(currentValue);
        return rangeStyles;
    }

    private RangeStyles computePartialThresholdRangeStyles(ThresholdValue thresholdValue, double currentValue) {
        Assertion.wilyAssert(thresholdValue != null && !thresholdValue.hasCaution());
        double dangerValue = thresholdValue.getDangerValue();
        RangeStyles rangeStyles = new RangeStyles(this.getDefaultRangeStyle());
        if (dangerValue > 0.0) {
            rangeStyles.addRangeStyle(new Range(Double.NEGATIVE_INFINITY, dangerValue, true, true), this.getBelowThresholdStyle());
            rangeStyles.addRangeStyle(new Range(dangerValue, Double.POSITIVE_INFINITY, false, true), this.getDangerThresholdExceededStyle());
        } else {
            rangeStyles.addRangeStyle(new Range(Double.POSITIVE_INFINITY, dangerValue, true, true), this.getBelowThresholdStyle());
            rangeStyles.addRangeStyle(new Range(dangerValue, Double.NEGATIVE_INFINITY, false, true), this.getDangerThresholdExceededStyle());
        }
        rangeStyles.setOrigin(0.0);
        rangeStyles.setCurrentValue(currentValue);
        return rangeStyles;
    }

    private RangeStyles computeFullThresholdRangeStyles(ThresholdValue thresholdValue, double currentValue) {
        double origin;
        Assertion.wilyAssert(thresholdValue != null && thresholdValue.hasCaution());
        RangeStyles rangeStyles = new RangeStyles(this.getDefaultRangeStyle());
        double warningValue = thresholdValue.getCautionValue();
        double dangerValue = thresholdValue.getDangerValue();
        if (thresholdValue.isGreaterThanComparison()) {
            rangeStyles.addRangeStyle(new Range(Double.NEGATIVE_INFINITY, warningValue, true, true), this.getBelowThresholdStyle());
            rangeStyles.addRangeStyle(new Range(warningValue, dangerValue, false, true), this.getWarningThresholdExceededStyle());
            rangeStyles.addRangeStyle(new Range(dangerValue, Double.POSITIVE_INFINITY, false, true), this.getDangerThresholdExceededStyle());
            origin = warningValue < 0.0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else {
            rangeStyles.addRangeStyle(new Range(Double.POSITIVE_INFINITY, warningValue, true, true), this.getBelowThresholdStyle());
            rangeStyles.addRangeStyle(new Range(warningValue, dangerValue, false, true), this.getWarningThresholdExceededStyle());
            rangeStyles.addRangeStyle(new Range(dangerValue, Double.NEGATIVE_INFINITY, false, true), this.getDangerThresholdExceededStyle());
            origin = warningValue > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
        }
        rangeStyles.setOrigin(origin);
        rangeStyles.setCurrentValue(currentValue);
        return rangeStyles;
    }

    protected static class RangeStyles {
        private Style fDefaultStyle;
        private Hashtable fRangeToStyleMap;
        private double fOrigin;
        private double fCurrentValue;

        public RangeStyles(Style defaultStyle) {
            this.fDefaultStyle = defaultStyle;
            this.fRangeToStyleMap = new Hashtable();
            this.fOrigin = 0.0;
            this.fCurrentValue = 0.0;
        }

        public void addRangeStyle(Range range, Style style) {
            this.fRangeToStyleMap.put(range, style);
        }

        public void setOrigin(double origin) {
            this.fOrigin = origin;
        }

        public void setCurrentValue(double currentValue) {
            this.fCurrentValue = currentValue;
        }

        public Style getRawStyleForValue(double value) {
            Style style = null;
            Enumeration ranges = this.fRangeToStyleMap.keys();
            while (ranges.hasMoreElements() && style == null) {
                Range candidateRange = (Range)ranges.nextElement();
                if (!candidateRange.valueInRange(value)) continue;
                style = (Style)this.fRangeToStyleMap.get(candidateRange);
            }
            if (style == null) {
                style = this.fDefaultStyle;
            }
            return style;
        }

        public Style getMaskedStyleForValue(double value) {
            Range currentValueRange = new Range(this.fOrigin, this.fCurrentValue);
            Style style = currentValueRange.valueInRange(value) ? this.getRawStyleForValue(value) : this.fDefaultStyle;
            return style;
        }

        public Style getAdjustedStyleForValue(double value) {
            Style style = this.getCurrentValueRange().valueInRange(value) ? this.getRawStyleForValue(this.fCurrentValue) : this.fDefaultStyle;
            return style;
        }

        public Style getStyleForRange(Range targetRange) {
            Style style = null;
            Enumeration ranges = this.fRangeToStyleMap.keys();
            while (ranges.hasMoreElements() && style == null) {
                Range candidateRange = (Range)ranges.nextElement();
                if (candidateRange.contains(targetRange)) {
                    style = (Style)this.fRangeToStyleMap.get(candidateRange);
                }
                if (style != null) continue;
                style = this.fDefaultStyle;
            }
            return this.fDefaultStyle;
        }

        public Style getCurrentValueStyle() {
            return this.getRawStyleForValue(this.fCurrentValue);
        }

        public Range getCurrentValueRange() {
            return new Range(this.fOrigin, this.fCurrentValue);
        }

        public String toString() {
            return this.fRangeToStyleMap.toString();
        }
    }

    protected static class Style {
        private Color fColor;
        private boolean fFill;

        public Style(Color color, boolean fill) {
            this.fColor = color;
            this.fFill = fill;
        }

        public Color getColor() {
            return this.fColor;
        }

        public boolean isFilled() {
            return this.fFill;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getClass().getName());
            buffer.append(": color = ");
            buffer.append(this.fColor);
            buffer.append(", fill = ");
            buffer.append(this.fFill);
            return buffer.toString();
        }
    }
}

