/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.external.biz.util.KExternalBizConstants;
import com.wily.introscope.agent.external.biz.util.MutableInteger;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.properties.AttributeListing;

public class SinglePerIntervalCounter
extends ASingleMetricTracerFactory {
    private Boolean isFeatureOn = false;
    private static DataAccumulatorFactory dataAccumulatorfactory;
    private static final String kValuePlaceHolder = "{value}";
    private static ThreadLocal stackDepthLocal;

    static {
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }

    public SinglePerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        dataAccumulatorfactory = agent.IAgent_getDataAccumulatorFactory();
        this.isFeatureOn = agent.IAgent_getComponentTracer().isAgentOldMode() ? Boolean.FALSE : Boolean.valueOf(this.getAgent().IAgent_getConfigurationManager().getProperty("introscope.agent.external.biz.enabled"));
    }

    public boolean ITracerFactory_isShutoff() {
        return this.isFeatureOn == false;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
        IBizTrx businessTransaction = (IBizTrx)data.get("BusinessTrxData");
        String pkey = this.getParameter("attributeKey");
        String pvalue = null;
        if (pkey != null && KExternalBizConstants.propertykeys.get(pkey) != null) {
            pvalue = (String)data.get(KExternalBizConstants.propertykeys.get(pkey));
        }
        if (businessTransaction != null && pvalue != null && !"".equalsIgnoreCase(pvalue)) {
            String formattedString = businessTransaction.getBizFullName() + ":" + this.getFormattedName().replace(kValuePlaceHolder, pvalue);
            ILongIntervalCounterDataAccumulator counter = dataAccumulatorfactory.safeGetBizTrxLongIntervalCounterDataAccumulator(formattedString);
            counter.ILongAggregatingDataAccumulator_recordDataPoint(1L);
        }
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }
}

