/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.Tasks.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.tibcobw.processes.nameformatter.ProcessNameFormatterHC;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoPPException;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class TaskNameFormatterHC
extends ProcessNameFormatterHC {
    private static final String FORMATTER_NAME = "TaskNameFormatter";

    public TaskNameFormatterHC(IAgent agent) {
        super(agent);
    }

    public String getTaskName(InvocationData data) {
        String taskname;
        block2: {
            taskname = null;
            try {
                Object objTask = data.getInvocationObject();
                taskname = this.getName(objTask);
            }
            catch (TibcoPPException e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
        return taskname;
    }

    private String getName(Object objTask) throws TibcoPPException {
        String taskname = null;
        try {
            taskname = (String)TibcoReflectionCache.getMTaskGetName(objTask).invoke(objTask, KConstants.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new TibcoPPException(FORMATTER_NAME, e.getMessage());
        }
        return taskname;
    }

    @Override
    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData invocationdata) {
        String taskname = this.getTaskName(invocationdata);
        String processName = super.getProcessName(invocationdata);
        return ABlameComponent.getArrayInstance((Object[])new Object[]{name, taskname, processName});
    }

    private String doTaskNaming(InvocationData data, boolean isDebugEnabled) {
        String taskName = null;
        taskName = (String)data.get("com.wily.soaextension.tibcobw.TaskNameKey");
        if ((taskName == null || taskName.equals("UnKnownTaskName")) && (taskName = this.getTaskName(data)) == null) {
            return "UnKnownTaskName";
        }
        taskName = TibcoBWUtils.formatToBeResourceSafe(taskName);
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("Found TaskName: " + taskName);
        }
        data.put("com.wily.soaextension.tibcobw.TaskNameKey", (Object)taskName);
        return taskName;
    }

    @Override
    public String INameFormatter_format(String name, InvocationData data) {
        String taskName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        if (name.indexOf("{taskname}", 0) >= 0) {
            taskName = this.doTaskNaming(data, isDebugEnabled);
            name = StringUtils.replace((String)name, (String)"{taskname}", (String)taskName);
        }
        return super.INameFormatter_format(name, data);
    }
}

