/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.Tasks.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoTracerUtil;
import com.wily.util.properties.AttributeListing;

public class TaskTracer
extends ASingleMetricTracerFactory {
    private static final String TRACER_NAME = "TaskTracer";
    private boolean showMetric = false;

    public TaskTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        ProbeIdentification probIdentification = data.getProbeInformation().getProbeIdentification();
        boolean threw = false;
        boolean handleerror = false;
        if (data.hasInvocationThrownException()) {
            threw = true;
        }
        if (probIdentification.getProbeMethodName().equalsIgnoreCase("handleError")) {
            handleerror = true;
        }
        if (threw || handleerror) {
            this.ifThrewAndHandleError(threw, data);
        }
    }

    private void ifThrewAndHandleError(boolean threw, InvocationData data) {
        String param;
        Throwable error = null;
        error = threw ? data.getInvocationThrownException() : (Throwable)data.getInvocationParameterAsObject(2);
        String component = this.formatParameterizedResource(data);
        String errorMessage = String.valueOf(component) + ": " + error.getMessage();
        if (data.getCursor() != null) {
            ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
            ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
        }
        if ((param = this.getParameter("showMetric")) != null) {
            this.showMetric = Boolean.parseBoolean(param);
        }
        if (this.showMetric) {
            if (data.getCursor() != null) {
                ErrorFeature.incrementErrorMetric((IStackElement)data);
            } else {
                IRepository errorsRepository = TibcoTracerUtil.createErrorsRespository(component, this.getDataAccumulatorFactory());
                TibcoTracerUtil.updateErrorMetric(errorsRepository, data);
            }
        }
        TibcoBWUtils.getLogger().debug(TRACER_NAME + errorMessage);
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }
}

