/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.activity.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.MethodThrewErrorReportingTracer;
import com.wily.soaextension.tibcobw.activity.tracer.XINodePropertiesCreator;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class ActivityExtendedTracer
extends MethodThrewErrorReportingTracer {
    private static final String CAUSE = "Cause";
    private static final String CODE = "Code";
    private static final String ERROR_DETAILS = "Error details";
    private boolean enableErrorDetails = false;
    public static final String ERROR_MESS = "Error retrieving activity error information: ";
    private static final XINodePropertiesCreator xiNodePropertiesCreator = new XINodePropertiesCreator();

    public ActivityExtendedTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String result = this.getParameter("enableErrorDetails");
        if (result != null) {
            try {
                this.enableErrorDetails = Boolean.parseBoolean(result);
            }
            catch (Exception e) {
                TibcoBWUtils.getLogger().error("Activities - enableErrorDetails variable must be true/false", (Throwable)e);
            }
        }
    }

    public void doFinishTrace(int tracerIndex, InvocationData data) {
        super.doFinishTrace(tracerIndex, data);
        if (data.hasInvocationThrownException()) {
            Object processContextObject;
            Throwable error = data.getInvocationThrownException();
            Object xiNodeData = this.receiveData(error);
            if (xiNodeData != null) {
                if (this.enableErrorDetails) {
                    xiNodePropertiesCreator.extractXINode(xiNodeData, this.getAgent().IAgent_getModuleFeedback(), this.getComponentTracer());
                } else {
                    this.getComponentTracer().addExtraParameter(ERROR_DETAILS, xiNodeData.toString());
                }
            }
            String code = this.receiveCode(error);
            this.getComponentTracer().addExtraParameter(CODE, code);
            Throwable exceptionCause = this.receiveExceptionCause(error);
            if (exceptionCause != null) {
                this.getComponentTracer().addExtraParameter(CAUSE, exceptionCause.toString());
            }
            if ((processContextObject = data.getInvocationParameterAsObject(0)) != null) {
                this.outputProcessContext(processContextObject);
            }
        }
    }

    private void outputProcessContext(Object processContext) {
        ComponentTracer componentTracer = this.getComponentTracer();
        try {
            Method getIdMethod = processContext.getClass().getMethod("getId", new Class[0]);
            getIdMethod.setAccessible(true);
            Method getNameMethod = processContext.getClass().getMethod("getName", new Class[0]);
            getNameMethod.setAccessible(true);
            Method getInvocationNameMethod = processContext.getClass().getMethod("getInvocationName", new Class[0]);
            getInvocationNameMethod.setAccessible(true);
            Method getServiceMethod = processContext.getClass().getMethod("getService", new Class[0]);
            getServiceMethod.setAccessible(true);
            componentTracer.addExtraParameter("Name", getNameMethod.invoke(processContext, new Object[0]).toString());
            componentTracer.addExtraParameter("Service", (String)getServiceMethod.invoke(processContext, new Object[0]));
        }
        catch (Exception e) {
            TibcoBWUtils.getLogger().warn(ERROR_MESS + e.getMessage(), (Throwable)e);
        }
    }

    private Throwable receiveExceptionCause(Throwable error) {
        try {
            Method getDataMethod = error.getClass().getMethod("getExceptionCause", new Class[0]);
            return (Throwable)getDataMethod.invoke((Object)error, new Object[0]);
        }
        catch (Exception e) {
            TibcoBWUtils.getLogger().warn(ERROR_MESS + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String receiveCode(Throwable error) {
        try {
            Method getDataMethod = error.getClass().getMethod("getCode", new Class[0]);
            return (String)getDataMethod.invoke((Object)error, new Object[0]);
        }
        catch (Exception e) {
            TibcoBWUtils.getLogger().warn(ERROR_MESS + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Object receiveData(Throwable error) {
        try {
            Method getDataMethod = error.getClass().getMethod("getData", new Class[0]);
            return getDataMethod.invoke((Object)error, new Object[0]);
        }
        catch (Exception e) {
            TibcoBWUtils.getLogger().warn(ERROR_MESS + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

