/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.activity.tracer;

import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;

public class XINodePropertiesCreator {
    private static final String HEADER = "Header";
    private static final String ROOT = "Root";
    protected static final String DOCUMENT = "document";
    protected static final String ELEMENT = "element";
    protected static final String ATTRIBUTE = "attribute";
    protected static final String TEXT = "text";
    protected static final String NAMESPACE = "namespace";
    protected static final String PROCESSING = "processing-instruction";
    protected static final String COMMENT = "comment";
    protected static final String FRAGMENT = "fragment";
    private static Method getNextSiblingMethod;
    private static Method getElementNameMethod;
    private static Method getLocalNameMethod;
    private static Method elementGetStringValueMethod;
    private static Method getAttributeNameMethod;
    private static Method attributeGetStringValueMethod;
    private static Method getChildrenMethod;
    private Method getAttributesMethods;
    private static final String ELEMENT_NAME = "Not defined";

    private static Method getGetNextSiblingMethod() {
        return getNextSiblingMethod;
    }

    private static void setGetNextSiblingMethod(Method getNextSiblingMethod) {
        XINodePropertiesCreator.getNextSiblingMethod = getNextSiblingMethod;
    }

    private static Method getGetElementNameMethod() {
        return getElementNameMethod;
    }

    private static void setGetElementNameMethod(Method getElementNameMethod) {
        XINodePropertiesCreator.getElementNameMethod = getElementNameMethod;
    }

    private static Method getGetLocalNameMethod() {
        return getLocalNameMethod;
    }

    private static void setGetLocalNameMethod(Method getLocalNameMethod) {
        XINodePropertiesCreator.getLocalNameMethod = getLocalNameMethod;
    }

    private static Method getGetAttributeNameMethod() {
        return getAttributeNameMethod;
    }

    private static void setGetAttributeNameMethod(Method getAttributeNameMethod) {
        XINodePropertiesCreator.getAttributeNameMethod = getAttributeNameMethod;
    }

    private static Method getAttributeGetStringValueMethod() {
        return attributeGetStringValueMethod;
    }

    private static void setAttributeGetStringValueMethod(Method attributeGetStringValueMethod) {
        XINodePropertiesCreator.attributeGetStringValueMethod = attributeGetStringValueMethod;
    }

    private static Method getGetChildrenMethod() {
        return getChildrenMethod;
    }

    private static void setGetChildrenMethod(Method getChildrenMethod) {
        XINodePropertiesCreator.getChildrenMethod = getChildrenMethod;
    }

    private static Method getElementGetStringValueMethod() {
        return elementGetStringValueMethod;
    }

    private static void setElementGetStringValueMethod(Method elementGetStringValueMethod) {
        XINodePropertiesCreator.elementGetStringValueMethod = elementGetStringValueMethod;
    }

    public void extractXINode(Object xiNodeData, IModuleFeedbackChannel moduleFeedback, ComponentTracer componentTracer) {
        try {
            this.interpretXINode(xiNodeData, moduleFeedback, componentTracer, ROOT);
        }
        catch (Exception e) {
            moduleFeedback.error("Error extracting Exception Parameters");
            moduleFeedback.error((Throwable)e);
            try {
                componentTracer.addExtraParameter("Exception content", xiNodeData.toString());
            }
            catch (Exception e2) {
                moduleFeedback.error("Error reporting Exception Parameters");
                moduleFeedback.error((Throwable)e2);
            }
        }
    }

    private void interpretXINode(Object xiNodeData, IModuleFeedbackChannel moduleFeedback, ComponentTracer componentTracer, String lastComponent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String nodeKind = this.extractNodeKind(xiNodeData, moduleFeedback);
        String elementName = ROOT;
        if (nodeKind.equals(DOCUMENT)) {
            this.extractDocumentData(xiNodeData, moduleFeedback, componentTracer, lastComponent);
        } else if (nodeKind.equals(ELEMENT)) {
            elementName = this.extractElementData(xiNodeData, componentTracer, lastComponent);
            if (elementName.startsWith(HEADER)) {
                elementName = HEADER;
            }
        } else if (nodeKind.equals(ATTRIBUTE)) {
            this.extractAttribute(xiNodeData, componentTracer, lastComponent);
        }
        if (nodeKind.equals(DOCUMENT) || nodeKind.equals(ELEMENT) || nodeKind.equals(FRAGMENT)) {
            this.extractChildren(xiNodeData, moduleFeedback, componentTracer, elementName);
        }
        this.handleAttributes(xiNodeData, moduleFeedback, componentTracer, elementName);
    }

    private void handleAttributes(Object xiNodeObject, IModuleFeedbackChannel moduleFeedback, ComponentTracer componentTracer, String lastComponent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (getAttributeNameMethod == null) {
            this.getAttributesMethods = xiNodeObject.getClass().getMethod("getAttributes", new Class[0]);
            this.getAttributesMethods.setAccessible(true);
        }
        Iterator attributeIterator = (Iterator)this.getAttributesMethods.invoke(xiNodeObject, new Object[0]);
        while (attributeIterator.hasNext()) {
            Object object = attributeIterator.next();
            this.interpretXINode(object, moduleFeedback, componentTracer, lastComponent);
        }
    }

    private void extractChildren(Object xiNodeData, IModuleFeedbackChannel moduleFeedback, ComponentTracer componentTracer, String lastComponent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (XINodePropertiesCreator.getGetChildrenMethod() == null) {
            XINodePropertiesCreator.setGetChildrenMethod(xiNodeData.getClass().getMethod("getChildren", new Class[0]));
            getChildrenMethod.setAccessible(true);
        }
        Iterator iterator = (Iterator)getChildrenMethod.invoke(xiNodeData, new Object[0]);
        while (iterator.hasNext()) {
            Object children = iterator.next();
            this.interpretXINode(children, moduleFeedback, componentTracer, lastComponent);
        }
    }

    private void extractAttribute(Object attribute, ComponentTracer componentTracer, String lastComponent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String value;
        if (XINodePropertiesCreator.getGetAttributeNameMethod() == null) {
            XINodePropertiesCreator.setGetAttributeNameMethod(attribute.getClass().getMethod("getName", new Class[0]));
            getAttributeNameMethod.setAccessible(true);
        }
        String elementName = ELEMENT_NAME;
        Object elementNameObject = getAttributeNameMethod.invoke(attribute, new Object[0]);
        if (elementNameObject != null) {
            String receivedName;
            if (XINodePropertiesCreator.getGetLocalNameMethod() == null) {
                XINodePropertiesCreator.setGetLocalNameMethod(elementNameObject.getClass().getMethod("getLocalName", new Class[0]));
                getLocalNameMethod.setAccessible(true);
            }
            if ((receivedName = (String)getLocalNameMethod.invoke(elementNameObject, new Object[0])) != null && !receivedName.trim().equals("")) {
                elementName = receivedName;
            }
        }
        if (XINodePropertiesCreator.getAttributeGetStringValueMethod() == null) {
            XINodePropertiesCreator.setAttributeGetStringValueMethod(attribute.getClass().getMethod("getStringValue", new Class[0]));
            attributeGetStringValueMethod.setAccessible(true);
        }
        if ((value = (String)attributeGetStringValueMethod.invoke(attribute, new Object[0])) != null && !value.trim().equals("")) {
            componentTracer.addExtraParameter(String.valueOf(lastComponent) + " - " + elementName, value);
        }
    }

    private String extractElementData(Object element, ComponentTracer componentTracer, String lastComponent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String value;
        if (XINodePropertiesCreator.getGetElementNameMethod() == null) {
            XINodePropertiesCreator.setGetElementNameMethod(element.getClass().getMethod("getName", new Class[0]));
            getElementNameMethod.setAccessible(true);
        }
        String elementName = ELEMENT_NAME;
        Object elementNameObject = getElementNameMethod.invoke(element, new Object[0]);
        if (elementNameObject != null) {
            String receivedName;
            if (XINodePropertiesCreator.getGetLocalNameMethod() == null) {
                XINodePropertiesCreator.setGetLocalNameMethod(elementNameObject.getClass().getMethod("getLocalName", new Class[0]));
                getLocalNameMethod.setAccessible(true);
            }
            if ((receivedName = (String)getLocalNameMethod.invoke(elementNameObject, new Object[0])) != null && !receivedName.trim().equals("")) {
                elementName = receivedName;
            }
        }
        if (XINodePropertiesCreator.getElementGetStringValueMethod() == null) {
            XINodePropertiesCreator.setElementGetStringValueMethod(element.getClass().getMethod("getStringValue", new Class[0]));
            elementGetStringValueMethod.setAccessible(true);
        }
        if ((value = (String)elementGetStringValueMethod.invoke(element, new Object[0])) != null && !value.trim().equals("")) {
            componentTracer.addExtraParameter(String.valueOf(lastComponent) + " - " + elementName, value);
        }
        return String.valueOf(elementName) + " - " + value;
    }

    private void extractDocumentData(Object document, IModuleFeedbackChannel moduleFeedback, ComponentTracer componentTracer, String lastComponent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (XINodePropertiesCreator.getGetNextSiblingMethod() == null) {
            XINodePropertiesCreator.setGetNextSiblingMethod(document.getClass().getMethod("getNextSibling", new Class[0]));
            getNextSiblingMethod.setAccessible(true);
        }
        Object nextSibling = null;
        do {
            if ((nextSibling = getNextSiblingMethod.invoke(document, new Object[0])) == null) continue;
            this.interpretXINode(nextSibling, moduleFeedback, componentTracer, lastComponent);
        } while (nextSibling != null);
    }

    private String extractNodeKind(Object xiNodeData, IModuleFeedbackChannel moduleFeedback) {
        try {
            Method getNodeKindMethod = xiNodeData.getClass().getMethod("getNodeKind", new Class[0]);
            Object nodeKind = getNodeKindMethod.invoke(xiNodeData, new Object[0]);
            if (nodeKind != null) {
                return nodeKind.toString();
            }
        }
        catch (Exception e) {
            moduleFeedback.error("Error extracting Node Kind");
            moduleFeedback.error((Throwable)e);
        }
        return ELEMENT_NAME;
    }
}

