/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.backend.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;

public class EMSBackendFormatter
implements INameFormatter {
    private static final String K_EMS_SERVER = "EMS-SERVER";
    private static final String K_TIBCO_EMS_SERVER = "TIBCO EMS Server";
    private static final String K_JMS_SERVER = "JMS Server";
    private static final String K_AT_STRING = " at ";
    private static final String K_URL_STRING = "URL=tcp://";
    private static final String K_ON_PORTSTRING = " on port ";
    private static final String K_REGEX = ".*:\\d*";
    private final IAgent fAgent;
    private boolean isHostPort = false;

    public EMSBackendFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String getEMSString(InvocationData data) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        String servername = null;
        String objString = null;
        String hostPort = null;
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("EMSBackendFormatter: getEMSString()");
        }
        try {
            Object connObj;
            Object emsObj = data.getInvocationParameterAsObject(1);
            objString = this.getMessageID(emsObj);
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("EMSBackendFormatter Message ID: " + objString);
            }
            if ((emsObj = data.getInvocationObject()) != null && (connObj = this.getConnection(emsObj)) != null) {
                hostPort = this.duringConnObjExist(connObj);
            }
            if (objString != null) {
                servername = this.duringObjStringExist(objString, hostPort);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("EMSBackendFormatter EMS Server String: " + servername);
            }
        }
        catch (Exception e) {
            TibcoBWUtils.handleError(this.fAgent, "EMSBackendFormatter error:", e);
        }
        return servername == null || servername.trim().length() == 0 || servername.equals("UnknownTibcoEMSServer") ? "UnknownTibcoEMSServer" : servername;
    }

    private String duringObjStringExist(String objString, String hostPort) {
        String servername = objString.contains(K_EMS_SERVER) ? (hostPort != null && this.isHostPort ? "TIBCO EMS Server at " + hostPort : K_TIBCO_EMS_SERVER) : (hostPort != null && this.isHostPort ? "JMS Server at " + hostPort : K_JMS_SERVER);
        return servername;
    }

    private String duringConnObjExist(Object connObj) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        String hostPort = null;
        String connString = connObj.toString();
        if (connString.contains(K_URL_STRING)) {
            int urlIndex = connString.indexOf(K_URL_STRING);
            int lastIndex = connString.lastIndexOf(93);
            hostPort = connString.substring(urlIndex + 10, lastIndex);
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("EMSBackendFormatter Host Port String_1: " + hostPort);
            }
            this.isHostPort = Pattern.matches(K_REGEX, hostPort);
            if (hostPort != null && this.isHostPort) {
                hostPort = hostPort.replace(":", K_ON_PORTSTRING);
                if (isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug("EMSBackendFormatter Host Port String_2: " + hostPort);
                }
            }
        }
        return hostPort;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String serverName = null;
        if (name.indexOf("{emsserver}", 0) >= 0) {
            serverName = (String)data.get("com.wily.soaextension.tibcobw.EMSServerKey");
            if ((serverName == null || serverName.equals("UnknownTibcoEMSServer")) && (serverName = this.getEMSString(data)) == null) {
                return "UnknownTibcoEMSServer";
            }
            serverName = TibcoBWUtils.formatToBeResourceSafe(serverName);
            data.put("com.wily.soaextension.tibcobw.EMSServerKey", (Object)serverName);
            name = StringUtils.replace((String)name, (String)"{emsserver}", (String)serverName);
        }
        return name;
    }

    private Object getConnection(Object emsobj) throws NoSuchFieldException, IllegalAccessException {
        Object connection = null;
        Field connF = TibcoReflectionCache.getFemsConnection(emsobj);
        if (connF != null) {
            connection = connF.get(emsobj);
        }
        return connection;
    }

    private String getMessageID(Object msg) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String msgID = null;
        msgID = (String)TibcoReflectionCache.getmGetJMSMessageID(msg).invoke(msg, KConstants.EMPTY_OBJECT_ARRAY);
        return msgID;
    }
}

