/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.soaextension.tibcobw.correlation.tracer.CorrelationTracer;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoMBBSUtil;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;

public class JMSServerCorrelationTracer
extends CorrelationTracer {
    public JMSServerCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!TibcoBWUtils.correlationJMSReadEnabled()) {
            return;
        }
        boolean debug = this.fLogger.isDebugEnabled();
        try {
            Object currentMessageObject = data.getInvocationParameterAsObject(1);
            String corIDAsString = (String)TibcoReflectionCache.getMGetObjectProperty(currentMessageObject, new Class[]{String.class}, new Object[]{"CorID"});
            if (corIDAsString == null || corIDAsString.equals("")) {
                corIDAsString = (String)TibcoReflectionCache.getMGetObjectProperty(currentMessageObject, new Class[]{String.class}, new Object[]{"CorIDForSOAPInvocation"});
            }
            if (corIDAsString == null || corIDAsString.equals("")) {
                if (debug) {
                    this.fLogger.debug("JMSServerCorrelationTracer ITracer_startTrace no correlation id in JMS Message");
                }
            } else {
                String prevCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                new CorrelationId(corIDAsString, true);
                SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
                if (debug) {
                    this.fLogger.debug("JMSServerCorrelationTracer NBThreadTxn = " + cache.getStringParamIn("NBThreadTxn"));
                }
                if (TibcoBWUtils.isMBBSEnabled()) {
                    String newCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                    TibcoMBBSUtil.updateFrontend(prevCorID, newCorID);
                }
            }
        }
        catch (Exception t) {
            this.fLogger.error("JMSServerCorrelationTracer ITracer_startTrace exception " + TibcoBWUtils.dumpStackTrace(t));
        }
    }
}

