/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.soaextension.tibcobw.correlation.tracer.CorrelationTracer;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class ProcessCorrelationTracer
extends CorrelationTracer {
    private static GUIDGenerator sGuidGenerator = GUIDGenerator.getInstance();
    private static final String[] excludeComponents = new String[]{"WebServices|Client", "Backends|"};

    public ProcessCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int traceIndex, InvocationData data) {
        Object ctxObj;
        HashMap<String, Object> ctxMap;
        SharedCrossProcessData cache1 = null;
        Object processContext = data.getInvocationParameterAsObject(0);
        Object correlationData = null;
        cache1 = this.getComponentTracer().getCrossProcessDataCache();
        String transactionId = cache1.getStringParamOut("TxnTraceId");
        if (transactionId == null) {
            String fTransactionIdentity = sGuidGenerator.generateKey();
            cache1.addParamOut("TxnTraceId", fTransactionIdentity);
        }
        if ((ctxMap = (ctxObj = data.get("Context_M")) == null ? this.getProcessContextMap(processContext) : (HashMap<String, SharedCrossProcessData.SerializableSharedCrossProcessData>)ctxObj) == null) {
            ctxMap = new HashMap<String, SharedCrossProcessData.SerializableSharedCrossProcessData>();
        }
        SharedCrossProcessData sharedCrossCache = this.getComponentTracer().getCrossProcessDataCache();
        sharedCrossCache.markNextCrossProcessCallAsNonBlocking();
        if (TibcoBWUtils.isSerializationEnabled()) {
            correlationData = sharedCrossCache.getOutgoingSerializableInstance();
            this.fLogger.debug("Cross Process data serialization is enabled, if checkpoints are failing change the property value to false");
        } else {
            correlationData = new ThreadCorrelationId().getOutgoingStringFromInstance();
        }
        ctxMap.put("CorID", correlationData);
        this.setProcessContextMap(processContext, ctxMap);
        data.put("Context_M", ctxMap);
    }

    private HashMap getProcessContextMap(Object processContext) {
        HashMap ctxMap = null;
        try {
            ctxMap = (HashMap)TibcoReflectionCache.getFJobM(processContext).get(processContext);
        }
        catch (Exception e) {
            this.fLogger.error("Exception in getProcessContextMap :" + e.toString());
        }
        return ctxMap;
    }

    private void setProcessContextMap(Object processContext, HashMap ctxMap) {
        try {
            TibcoReflectionCache.getFJobM(processContext).set(processContext, ctxMap);
        }
        catch (Exception e) {
            this.fLogger.error("Exception in setProcessContextMap :" + e.toString());
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        block4: {
            Object processContext = data.getInvocationParameterAsObject(0);
            boolean isDebugEnabled = this.fLogger.isDebugEnabled();
            try {
                Object ctxObj = data.get("Context_M");
                HashMap ctxMap = ctxObj == null ? this.getProcessContextMap(processContext) : (HashMap)ctxObj;
                if (ctxMap == null) {
                    ctxMap = new HashMap();
                }
                if (ctxMap.containsKey("CorID")) {
                    this.ctxContainsCorrattr(ctxMap, isDebugEnabled);
                }
            }
            catch (Exception e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block4;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
    }

    private void ctxContainsCorrattr(HashMap ctxMap, boolean isDebugEnabled) {
        Object correlationData = null;
        SharedCrossProcessData sharedCache = ComponentTracer.staticGetCrossProcessDataCache();
        if (TibcoBWUtils.isSerializationEnabled()) {
            correlationData = ctxMap.get("CorID");
            sharedCache.syncCache((SharedCrossProcessData.SerializableSharedCrossProcessData)correlationData);
        } else {
            correlationData = ctxMap.get("CorID");
            new ThreadCorrelationId((String)correlationData);
        }
        if (isDebugEnabled) {
            this.fLogger.debug("ProcessCorrelationTracer Correlation ID :" + correlationData);
        }
        if (isDebugEnabled) {
            this.fLogger.debug("ProcessCorrelationTracer NBThreadTxn = " + sharedCache.getStringParamIn("NBThreadTxn"));
        }
        this.getComponentTracer();
        if (ComponentTracer.staticGetCrossProcessDataCache().getIncomingCalledByNodeId().contains(excludeComponents[0]) || ComponentTracer.staticGetCrossProcessDataCache().getIncomingCalledByNodeId().contains(excludeComponents[1])) {
            this.getComponentTracer();
            ComponentTracer.staticGetCrossProcessDataCache().setIncomingCalledByNodeId("");
        }
    }
}

