/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.soaextension.tibcobw.correlation.tracer.ClientCorrelationTracer;
import com.wily.soaextension.tibcobw.util.BWObfuscationHelper;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class SOAPClientCorrrelationTracer
extends ClientCorrelationTracer {
    private static final String C_EXPANDED_NAME = "com.tibco.xml.data.primitive.ExpandedName";
    private static final String C_XML_ELEMENT_HELPER = "com.tibco.xml.soap.helpers.XmlElementHelper";
    private static final String C_XML_CURSOR = "com.tibco.xml.data.cursor.XmlCursor";
    private static final String C_SOAP_MESSAGE = "com.tibco.xml.soap.api.SoapMessage";
    private static final String C_CONTEXT_UTILS = "com.tibco.spin.utils.ContextUtils";
    private static Class clazzExpandedName = null;
    private static Class clazzXmlElementHelper = null;
    private static Class clazzXmlCursor = null;
    private static Class clazzSoapMessage = null;
    private static Class clazzContextUtil = null;
    private static Object corIDAttribute = null;
    private static Object expandedname = null;

    private static Class getClazzExpandedName() {
        return clazzExpandedName;
    }

    private static void setClazzExpandedName(Class clazzExpandedName) {
        SOAPClientCorrrelationTracer.clazzExpandedName = clazzExpandedName;
    }

    private static Class getClazzXmlElementHelper() {
        return clazzXmlElementHelper;
    }

    private static void setClazzXmlElementHelper(Class clazzXmlElementHelper) {
        SOAPClientCorrrelationTracer.clazzXmlElementHelper = clazzXmlElementHelper;
    }

    private static Class getClazzXmlCursor() {
        return clazzXmlCursor;
    }

    private static void setClazzXmlCursor(Class clazzXmlCursor) {
        SOAPClientCorrrelationTracer.clazzXmlCursor = clazzXmlCursor;
    }

    private static Class getClazzSoapMessage() {
        return clazzSoapMessage;
    }

    private static void setClazzSoapMessage(Class clazzSoapMessage) {
        SOAPClientCorrrelationTracer.clazzSoapMessage = clazzSoapMessage;
    }

    private static Class getClazzContextUtil() {
        return clazzContextUtil;
    }

    private static void setClazzContextUtil(Class clazzContextUtil) {
        SOAPClientCorrrelationTracer.clazzContextUtil = clazzContextUtil;
    }

    private static Object getCorIDAttribute() {
        return corIDAttribute;
    }

    private static void setCorIDAttribute(Object corIDAttribute) {
        SOAPClientCorrrelationTracer.corIDAttribute = corIDAttribute;
    }

    private static Object getExpandedname() {
        return expandedname;
    }

    private static void setExpandedname(Object expandedname) {
        SOAPClientCorrrelationTracer.expandedname = expandedname;
    }

    public SOAPClientCorrrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void printSOAPMessage(Object soapMessage, InvocationData data, Class clazzSoapMessage, String comment) {
        try {
            Object soapMessageAsString = null;
            ClassLoader loader = data.getInvocationObject().getClass().getClassLoader();
            if (BWObfuscationHelper.isContainer()) {
                SOAPClientCorrrelationTracer.setClazzContextUtil(Class.forName(C_CONTEXT_UTILS, false, loader));
            } else if (SOAPClientCorrrelationTracer.getClazzContextUtil() == null) {
                SOAPClientCorrrelationTracer.setClazzContextUtil(Class.forName(C_CONTEXT_UTILS, false, loader));
            }
            soapMessageAsString = TibcoBWUtils.invokeMethodOnClass(clazzContextUtil, KConstants.KM_CONTEXTUTILS_GETSOAPMESSAGEASSTRING, new Class[]{clazzSoapMessage}, new Object[]{soapMessage});
            this.fLogger.debug("printSOAPMessage ::" + comment + "Outbound SoapMessage :" + soapMessageAsString);
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("printSOAPMessage :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("printSOAPMessage :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("printSOAPMessage :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("printSOAPMessage :: InvocationTargetException" + bomb.getCause().getMessage());
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean debug = false;
        if (!TibcoBWUtils.correlationSOAPInsertionEnabled()) {
            return;
        }
        Object soapMessage = null;
        Object msgContext = null;
        List soapHeaders = null;
        try {
            this.checkClasses(data);
            msgContext = data.getInvocationParameterAsObject(0);
            soapMessage = TibcoReflectionCache.getMMessageContextGetSoapMessage(msgContext);
            if (BWObfuscationHelper.isContainer()) {
                SOAPClientCorrrelationTracer.setExpandedname(TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.M_EXPANDEDNAME_MAKENAME, new Class[]{String.class, String.class}, new Object[]{"http://www.wilytech.com/", "WSCorIDSOAPHeader"}));
            } else if (SOAPClientCorrrelationTracer.getExpandedname() == null) {
                SOAPClientCorrrelationTracer.setExpandedname(TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.M_EXPANDEDNAME_MAKENAME, new Class[]{String.class, String.class}, new Object[]{"http://www.wilytech.com/", "WSCorIDSOAPHeader"}));
            }
            Method mSoapMessage = TibcoReflectionCache.getMSoapMessageGetSoapHeaderBlocks(soapMessage);
            Object soapHeadersObj = mSoapMessage.invoke(soapMessage, KConstants.EMPTY_OBJECT_ARRAY);
            if (soapHeadersObj != null) {
                soapHeaders = (List)soapHeadersObj;
            }
            Object corIdHeaderElement = TibcoBWUtils.invokeMethodOnClass(SOAPClientCorrrelationTracer.getClazzXmlElementHelper(), KConstants.M_XMLELEMENTHELPER_CREATEXMLELEMENT);
            Object xmlcursor = TibcoReflectionCache.getMXinXmlElementGetXmlCursor(corIdHeaderElement);
            Object[] objectArray = new Object[3];
            objectArray[0] = expandedname;
            objectArray[1] = "WSCorIDSOAPHeader";
            TibcoReflectionCache.getMXmlCursorCreateElement(xmlcursor, new Class[]{clazzExpandedName, String.class, SOAPClientCorrrelationTracer.getClazzXmlCursor()}, objectArray);
            SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
            cache.markNextCrossProcessCallAsNonBlocking();
            TibcoReflectionCache.getMXmlCursorSetAttributeStringValue(xmlcursor, new Class[]{clazzExpandedName, String.class}, new Object[]{corIDAttribute, new CorrelationId().getOutgoingCorrelationIdStrippedForHeader()});
            debug = this.fLogger.isDebugEnabled();
            if (debug) {
                this.printSOAPMessage(soapMessage, data, clazzSoapMessage, "Before Inserting the SOAP Header");
            }
            if (soapHeaders != null) {
                soapHeaders.add(corIdHeaderElement);
            }
            if (debug) {
                this.printSOAPMessage(soapMessage, data, clazzSoapMessage, "After Inserting the SOAP Header");
            }
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: InvocationTargetException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
    }

    private void checkClasses(InvocationData data) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader loader = data.getInvocationObject().getClass().getClassLoader();
        this.expandedNameReflection(loader);
        this.elementHelperReflection(loader);
        if (BWObfuscationHelper.isContainer()) {
            SOAPClientCorrrelationTracer.setClazzXmlCursor(Class.forName(C_XML_CURSOR, false, loader));
        } else if (clazzXmlCursor == null) {
            SOAPClientCorrrelationTracer.setClazzXmlCursor(Class.forName(C_XML_CURSOR, false, loader));
        }
        if (BWObfuscationHelper.isContainer()) {
            SOAPClientCorrrelationTracer.setClazzSoapMessage(Class.forName(C_SOAP_MESSAGE, false, loader));
        } else if (SOAPClientCorrrelationTracer.getClazzSoapMessage() == null) {
            SOAPClientCorrrelationTracer.setClazzSoapMessage(Class.forName(C_SOAP_MESSAGE, false, loader));
        }
        if (BWObfuscationHelper.isContainer()) {
            SOAPClientCorrrelationTracer.setCorIDAttribute(TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.M_EXPANDEDNAME_MAKENAME, new Class[]{String.class}, new Object[]{"CorID"}));
        } else if (SOAPClientCorrrelationTracer.getCorIDAttribute() == null) {
            SOAPClientCorrrelationTracer.setCorIDAttribute(TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.M_EXPANDEDNAME_MAKENAME, new Class[]{String.class}, new Object[]{"CorID"}));
        }
    }

    private void elementHelperReflection(ClassLoader loader) throws ClassNotFoundException {
        if (BWObfuscationHelper.isContainer()) {
            SOAPClientCorrrelationTracer.setClazzXmlElementHelper(Class.forName(C_XML_ELEMENT_HELPER, false, loader));
        } else if (clazzXmlElementHelper == null) {
            SOAPClientCorrrelationTracer.setClazzXmlElementHelper(Class.forName(C_XML_ELEMENT_HELPER, false, loader));
        }
    }

    private void expandedNameReflection(ClassLoader loader) throws ClassNotFoundException {
        if (BWObfuscationHelper.isContainer()) {
            SOAPClientCorrrelationTracer.setClazzExpandedName(Class.forName(C_EXPANDED_NAME, false, loader));
        } else if (SOAPClientCorrrelationTracer.getClazzExpandedName() == null) {
            SOAPClientCorrrelationTracer.setClazzExpandedName(Class.forName(C_EXPANDED_NAME, false, loader));
        }
    }

    @Override
    public void ITracer_finishTrace(int index, InvocationData data) {
        if (TibcoBWUtils.correlationSOAPInsertionEnabled()) {
            super.ITracer_finishTrace(index, data);
        }
    }
}

