/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.soaextension.tibcobw.correlation.tracer.CorrelationTracer;
import com.wily.soaextension.tibcobw.util.BWObfuscationHelper;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoMBBSUtil;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class SOAPServerCorrelationTracer
extends CorrelationTracer {
    private static final String C_EXPAND_NAME = "com.tibco.xml.data.primitive.ExpandedName";
    private static final String C_CONTEXT_UTILS = "com.tibco.spin.utils.ContextUtils";
    private static final String C_SOAP_MESSAGE = "com.tibco.xml.soap.api.SoapMessage";
    private static Class clazzExpandedName = null;
    private static Class clazzContextUtils = null;
    private static Class clazzSoapMessage = null;
    private static Object corIDAttribute = null;

    private static Class getClazzExpandedName() {
        return clazzExpandedName;
    }

    private static void setClazzExpandedName(Class clazzExpandedName) {
        SOAPServerCorrelationTracer.clazzExpandedName = clazzExpandedName;
    }

    private static Class getClazzContextUtils() {
        return clazzContextUtils;
    }

    private static void setClazzContextUtils(Class clazzContextUtils) {
        SOAPServerCorrelationTracer.clazzContextUtils = clazzContextUtils;
    }

    private static Class getClazzSoapMessage() {
        return clazzSoapMessage;
    }

    private static void setClazzSoapMessage(Class clazzSoapMessage) {
        SOAPServerCorrelationTracer.clazzSoapMessage = clazzSoapMessage;
    }

    private static Object getCorIDAttribute() {
        return corIDAttribute;
    }

    private static void setCorIDAttribute(Object corIDAttribute) {
        SOAPServerCorrelationTracer.corIDAttribute = corIDAttribute;
    }

    public SOAPServerCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void printSOAPMessage(Object soapMessage, InvocationData data, String prependMsg) {
        try {
            Object soapMessageAsString = null;
            ClassLoader loader = data.getInvocationParameterAsObject(1).getClass().getClassLoader();
            if (BWObfuscationHelper.isContainer()) {
                SOAPServerCorrelationTracer.setClazzContextUtils(Class.forName(C_CONTEXT_UTILS, false, loader));
            } else if (SOAPServerCorrelationTracer.getClazzContextUtils() == null) {
                SOAPServerCorrelationTracer.setClazzContextUtils(Class.forName(C_CONTEXT_UTILS, false, loader));
            }
            if (BWObfuscationHelper.isContainer()) {
                SOAPServerCorrelationTracer.setClazzSoapMessage(Class.forName(C_SOAP_MESSAGE, false, loader));
            } else if (SOAPServerCorrelationTracer.getClazzSoapMessage() == null) {
                SOAPServerCorrelationTracer.setClazzSoapMessage(Class.forName(C_SOAP_MESSAGE, false, loader));
            }
            soapMessageAsString = TibcoBWUtils.invokeMethodOnClass(clazzContextUtils, KConstants.KM_CONTEXTUTILS_GETSOAPMESSAGEASSTRING, new Class[]{clazzSoapMessage}, new Object[]{soapMessage});
            this.fLogger.debug(String.valueOf(prependMsg) + " " + soapMessageAsString);
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("printSOAPMessage :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("printSOAPMessage :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("printSOAPMessage :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("printSOAPMessage :: InvocationTargetException" + bomb.getCause().getMessage());
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean debug = false;
        if (!TibcoBWUtils.correlationSOAPReadEnabled()) {
            return;
        }
        Object soapMessage = null;
        List soapHeaders = null;
        try {
            this.checkClasseLoading(data);
            soapMessage = data.getInvocationParameterAsObject(1);
            Method mSoapMessage = TibcoReflectionCache.getMSoapMessageGetSoapHeaderBlocks(soapMessage);
            Object soapHeadersObj = mSoapMessage.invoke(soapMessage, KConstants.EMPTY_OBJECT_ARRAY);
            if (soapHeadersObj != null) {
                soapHeaders = (List)soapHeadersObj;
            }
            if (debug = this.fLogger.isDebugEnabled()) {
                this.printSOAPMessage(soapMessage, data, "SOAP Message at server side Before Processing :");
            }
            if (soapHeaders != null && !soapHeaders.isEmpty()) {
                this.duringSoapHeadersExist(soapHeaders, debug, soapMessage, data);
            }
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: InvocationTargetException" + bomb.getCause().getMessage());
        }
    }

    private void checkClasseLoading(InvocationData data) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader loader = data.getInvocationParameterAsObject(1).getClass().getClassLoader();
        if (BWObfuscationHelper.isContainer()) {
            SOAPServerCorrelationTracer.setClazzExpandedName(Class.forName(C_EXPAND_NAME, false, loader));
        } else if (SOAPServerCorrelationTracer.getClazzExpandedName() == null) {
            SOAPServerCorrelationTracer.setClazzExpandedName(Class.forName(C_EXPAND_NAME, false, loader));
        }
        if (BWObfuscationHelper.isContainer()) {
            SOAPServerCorrelationTracer.setCorIDAttribute(TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.M_EXPANDEDNAME_MAKENAME, new Class[]{String.class}, new Object[]{"CorID"}));
        } else if (SOAPServerCorrelationTracer.getCorIDAttribute() == null) {
            SOAPServerCorrelationTracer.setCorIDAttribute(TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.M_EXPANDEDNAME_MAKENAME, new Class[]{String.class}, new Object[]{"CorID"}));
        }
    }

    private void duringSoapHeadersExist(List soapHeaders, boolean debug, Object soapMessage, InvocationData data) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String correlationIdAsString = "";
        Object headerElement2 = null;
        Object xiNode = null;
        Object attribute = null;
        boolean hasCorId = false;
        for (Object headerElement2 : soapHeaders) {
            xiNode = TibcoReflectionCache.getMXinXmlElementGetElement(headerElement2);
            attribute = TibcoReflectionCache.getMXiNodeGetAttribute(xiNode, new Class[]{clazzExpandedName}, new Object[]{corIDAttribute});
            if (attribute == null) continue;
            Method mAttribute = TibcoReflectionCache.getMAttributeGetStringValue(attribute);
            Object correlationIdObj = mAttribute.invoke(attribute, KConstants.EMPTY_OBJECT_ARRAY);
            if (correlationIdObj != null) {
                correlationIdAsString = (String)correlationIdObj;
            }
            String prevCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
            new CorrelationId(correlationIdAsString, true);
            String newCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
            this.updateFrontEnd(prevCorID, newCorID, debug);
            hasCorId = true;
            break;
        }
        if (hasCorId) {
            soapHeaders.remove(headerElement2);
            if (debug) {
                this.printSOAPMessage(soapMessage, data, "SOAP Message at server side After Processing : ");
            }
        } else {
            new CorrelationId();
        }
    }

    private void updateFrontEnd(String prevCorID, String newCorID, boolean debug) {
        if (TibcoBWUtils.isMBBSEnabled()) {
            TibcoMBBSUtil.updateFrontend(prevCorID, newCorID);
        }
        if (debug) {
            this.fLogger.debug("SOAPServerCorrelationTracer ITracer_startTrace :: Override with new correlationId" + newCorID);
        }
    }
}

