/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.soaextension.tibcobw.correlation.tracer.CorrelationTracer;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class SpawnedProcessCorrelationTracer
extends CorrelationTracer {
    private static GUIDGenerator sGuidGenerator = GUIDGenerator.getInstance();

    public SpawnedProcessCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private HashMap getProcessContextMap(Object processContext) {
        HashMap ctxMap = null;
        try {
            ctxMap = (HashMap)TibcoReflectionCache.getFJobM(processContext).get(processContext);
        }
        catch (Exception e) {
            this.fLogger.error("SpawnedProcessCorrelationTracer::Error in getProcessContextMap :" + TibcoBWUtils.dumpStackTrace(e));
        }
        return ctxMap;
    }

    private void setCorInfoInParentProcess(Object parentContext) {
        HashMap<String, SharedCrossProcessData.SerializableSharedCrossProcessData> ctxMap;
        SharedCrossProcessData cacheG = null;
        Object correlationData = null;
        cacheG = this.getComponentTracer().getCrossProcessDataCache();
        String transactionId = cacheG.getStringParamOut("TxnTraceId");
        if (transactionId == null) {
            String fTransactionIdentity = sGuidGenerator.generateKey();
            cacheG.addParamOut("TxnTraceId", fTransactionIdentity);
        }
        if ((ctxMap = this.getProcessContextMap(parentContext)) == null) {
            ctxMap = new HashMap<String, SharedCrossProcessData.SerializableSharedCrossProcessData>();
        }
        new CorrelationId();
        SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
        cache.markNextCrossProcessCallAsNonBlocking();
        correlationData = TibcoBWUtils.isSerializationEnabled() ? cache.getOutgoingSerializableInstance() : new ThreadCorrelationId().getOutgoingStringFromInstance();
        if (correlationData != null) {
            ctxMap.put("CorID", (SharedCrossProcessData.SerializableSharedCrossProcessData)correlationData);
        }
        this.setProcessContextMap(parentContext, ctxMap);
    }

    private void setProcessContextMap(Object processContext, HashMap ctxMap) {
        try {
            TibcoReflectionCache.getFJobM(processContext).set(processContext, ctxMap);
        }
        catch (Exception e) {
            this.fLogger.debug("SpawnedProcessCorrelationTracer::Error in setProcessContextMap :" + e.toString());
        }
    }

    @Override
    public void ITracer_finishTrace(int i, InvocationData data) {
        try {
            Object parentProcessContext = data.getInvocationObject();
            boolean debug = this.fLogger.isDebugEnabled();
            Object correlationData = null;
            this.setCorInfoInParentProcess(parentProcessContext);
            Object spawnedProcessContext = data.getInvocationReturnValueAsObject();
            HashMap parentCtxMap = this.getProcessContextMap(parentProcessContext);
            HashMap<String, String> spawnedCtxMap = this.getProcessContextMap(spawnedProcessContext);
            if (parentCtxMap == null) {
                parentCtxMap = new HashMap();
            }
            if (spawnedCtxMap == null) {
                spawnedCtxMap = new HashMap<String, String>();
            }
            if (parentCtxMap.containsKey("CorID")) {
                correlationData = TibcoBWUtils.isSerializationEnabled() ? (Object)parentCtxMap.get("CorID") : (Object)parentCtxMap.get("CorID");
                if (debug) {
                    this.fLogger.debug("Found Correlation ID from Parent Job:" + correlationData);
                }
                if (correlationData != null) {
                    spawnedCtxMap.put("CorID", (String)correlationData);
                }
                this.setProcessContextMap(spawnedProcessContext, spawnedCtxMap);
                spawnedCtxMap.put("is_Spawned", "true");
            } else if (debug) {
                this.fLogger.debug("Could not set the Correlation Id in spawned job.");
            }
            data.IParameterizedMethodTracer_setReturnValue(spawnedProcessContext);
        }
        catch (Exception exception) {
            this.fLogger.debug("SpawnedProcessCorrelationTracer:ITracer_finishTrace : Error in correlation");
        }
        super.ITracer_finishTrace(i, data);
    }
}

