/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.ArrayList;

public class ExecInfoMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static ExecInfoMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String COMP = "ExecInfo";
    private static final String K_STATUS = "Status";
    private static final String ERROR_IN_HAWKMONITOR_EXECINFOS = "ERROR_IN_HAWKMONITOR_EXECINFOS";

    private ExecInfoMonitor(IAgent agent) {
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static ExecInfoMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new ExecInfoMonitor(agent);
        }
        return instance;
    }

    public void init() {
        try {
            if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                TibcoBWUtils.getLogger().debug("init method");
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_EXECINFOS, bomb);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getExecInfoMetrics(obj);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_EXECINFOS, bomb);
        }
    }

    private void getExecInfoMetrics(Object methodObj) {
        try {
            TibcoBWUtils.getLogger().debug("ExecInfoMonitor.getExecInfoMetrics()");
            Object hawkMicroAgent = TibcoBWUtils.getField(methodObj, KConstants.KF_HAWKMICROAGENTMETHODFIELD);
            Object jobPool = TibcoBWUtils.getField(hawkMicroAgent, KConstants.KF_HAWKMICROAGENTFIELD);
            String adapterString = (String)TibcoBWUtils.invokeMethodOnObject(jobPool, KConstants.KM_JOBPOOL_GETNAME);
            TibcoBWUtils.getLogger().debug("ExecInfoMonitor Adapter String: " + adapterString);
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[1]);
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("ExecInfo Size: " + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{i});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
                        if (value != null) {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                            this.reportMetric("ExecInfo|" + adapterString, name, value.toString());
                        } else {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                            this.reportMetric("ExecInfo|" + adapterString, name, "");
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_EXECINFOS, bomb);
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            if (name.equals(K_STATUS)) {
                this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
            } else {
                if (value == "") {
                    value = "0";
                }
                this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_EXECINFOS, bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }
}

