/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;

public class HawkMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static final String C_AMI_PARAMETER_LIST = "COM.TIBCO.hawk.ami.AmiParameterList";
    private static final String M_ON_INVOKE = "onInvoke";
    private Object execInfoMethodObject = null;
    private Object processDefsMethodObject = null;
    private Object memoryUsageMethodObject = null;
    private Object processStartersMethodObject = null;
    private Object serviceInfosMethodObject = null;
    private static HawkMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private static final String ERROR_IN_HAWKMONITOR = "ERROR_IN_HAWKMONITOR";
    private static final String SIZE = "Size: ";
    private static final String GET_PARAMETER = "getParameter";
    private static final String GET_NAME = "getName";
    private static final String GET_VALUE = "getValue";

    public HawkMonitor(IAgent agent) {
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static HawkMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new HawkMonitor(agent);
        }
        return instance;
    }

    public void init() {
        try {
            TibcoBWUtils.getLogger().debug("init method");
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            if (this.execInfoMethodObject != null) {
                TibcoBWUtils.getLogger().info("getExecInfoMetrics");
                this.getExecInfoMetrics(this.execInfoMethodObject);
            }
            if (this.processDefsMethodObject != null) {
                TibcoBWUtils.getLogger().info("getProcessDefsMetrics");
                this.getProcessDefsMetrics(this.processDefsMethodObject);
            }
            if (this.memoryUsageMethodObject != null) {
                TibcoBWUtils.getLogger().info("getMemoryUsageMetrics");
                this.getMemoryUsageMetrics(this.memoryUsageMethodObject);
            }
            if (this.processStartersMethodObject != null) {
                TibcoBWUtils.getLogger().info("getProcessStartersMetrics");
                this.getProcessStartersMetrics(this.processStartersMethodObject);
            }
            if (this.serviceInfosMethodObject != null) {
                TibcoBWUtils.getLogger().info("getServiceInfosMetrics");
                this.getServiceInfosMetrics(this.serviceInfosMethodObject);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    private void getServiceInfosMetrics(Object methodObj) {
        try {
            Class<?> amiParameterList = Class.forName(C_AMI_PARAMETER_LIST, false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, M_ON_INVOKE, new Class[]{amiParameterList}, new Object[1]);
            String comp = "ServiceInfos";
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug(SIZE + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, GET_PARAMETER, new Class[]{Integer.TYPE}, new Object[]{i});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, GET_NAME);
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, GET_VALUE);
                        if (value != null) {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                            this.reportMetric(comp, name, value.toString());
                        } else {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                            this.reportMetric(comp, name, null);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    private void getProcessStartersMetrics(Object methodObj) {
        String processName = null;
        try {
            Class<?> amiParameterList = Class.forName(C_AMI_PARAMETER_LIST, false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, M_ON_INVOKE, new Class[]{amiParameterList}, new Object[1]);
            String comp = "ProcessStarters";
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug(SIZE + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, GET_PARAMETER, new Class[]{Integer.TYPE}, new Object[]{i});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, GET_NAME);
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, GET_VALUE);
                        if (i == 0 || i == 11 || i == 22 || i == 33 || i == 44) {
                            processName = value.toString();
                        }
                        TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                        this.reportMetric(String.valueOf(comp) + "|" + processName, name, value.toString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    private void getMemoryUsageMetrics(Object methodObj) {
        try {
            Class<?> amiParameterList = Class.forName(C_AMI_PARAMETER_LIST, false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, M_ON_INVOKE, new Class[]{amiParameterList}, new Object[1]);
            String comp = "MemoryUsage";
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug(SIZE + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, GET_PARAMETER, new Class[]{Integer.TYPE}, new Object[]{i});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, GET_NAME);
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, GET_VALUE);
                        TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                        this.reportMetric(comp, name, value.toString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    private void getExecInfoMetrics(Object methodObj) {
        try {
            Class<?> amiParameterList = Class.forName(C_AMI_PARAMETER_LIST, false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, M_ON_INVOKE, new Class[]{amiParameterList}, new Object[1]);
            String comp = "ExecInfo";
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug(SIZE + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, GET_PARAMETER, new Class[]{Integer.TYPE}, new Object[]{i});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, GET_NAME);
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, GET_VALUE);
                        TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                        this.reportMetric(comp, name, value.toString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    private void getProcessDefsMetrics(Object methodObj) {
        String processName = null;
        try {
            Class<?> amiParameterList = Class.forName(C_AMI_PARAMETER_LIST, false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, M_ON_INVOKE, new Class[]{amiParameterList}, new Object[1]);
            String comp = "ProcessDefs";
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug(SIZE + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, GET_PARAMETER, new Class[]{Integer.TYPE}, new Object[]{i});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, GET_NAME);
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, GET_VALUE);
                        if (i == 0 || i == 21 || i == 42 || i == 63) {
                            processName = value.toString();
                        }
                        TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                        this.reportMetric(String.valueOf(comp) + "|" + processName, name, value.toString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR, bomb);
        }
    }

    public void registerMethodObject(String className, Object methodObj) {
        if (className.contains("GetExecInfoMethod")) {
            this.execInfoMethodObject = methodObj;
        } else if (className.contains("GetProcessDefsMethod")) {
            this.processDefsMethodObject = methodObj;
        } else if (className.contains("GetMemoryUsageMethod")) {
            this.memoryUsageMethodObject = methodObj;
        } else if (className.contains("GetProcessStartersMethod")) {
            this.processStartersMethodObject = methodObj;
        } else if (className.contains("GetServiceInfosHAWKMethod")) {
            this.serviceInfosMethodObject = methodObj;
        }
    }
}

