/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.ArrayList;

public class MemoryUsageMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static MemoryUsageMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String COMP = "MemoryUsage";
    private static final String ERROR_IN_HAWKMONITOR_MEMORYUSAGE = "ERROR_IN_HAWKMONITOR_MEMORYUSAGE";

    private MemoryUsageMonitor(IAgent agent) {
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static MemoryUsageMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new MemoryUsageMonitor(agent);
        }
        return instance;
    }

    public void init() {
        try {
            if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                TibcoBWUtils.getLogger().debug("init method");
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_MEMORYUSAGE, bomb);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getMemoryUsageMetrics(obj);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_MEMORYUSAGE, bomb);
        }
    }

    private void getMemoryUsageMetrics(Object methodObj) {
        try {
            TibcoBWUtils.getLogger().debug("MemoryUsageMonitor.getMemoryUsageMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[1]);
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("MemoryUsage Size: " + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{i});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
                        if (value != null) {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                            this.reportMetric(COMP, name, value.toString());
                        } else {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                            this.reportMetric(COMP, name, "0");
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_MEMORYUSAGE, bomb);
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_MEMORYUSAGE, bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }
}

