/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class ProcessDefsMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static ProcessDefsMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String COMP = "ProcessDefs";
    private Object activitiesMethodObject = null;
    private static final String K_NAME = "Name";
    private static final String K_STARTER = "Starter";
    private static final String K_TRACING = "Tracing";
    private static final String K_LAST_RETURN_CODE = "LastReturnCode";
    private static final String K_CALLED_PROCESS_DEFS = "CalledProcessDefs";
    private static final String K_ACTIVITY_CLASS = "ActivityClass";
    private static final String ERROR_IN_HAWKMONITOR_PROCESSDEFS = "ERROR_IN_HAWKMONITOR_PROCESSDEFS";

    public ProcessDefsMonitor(IAgent agent) {
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static ProcessDefsMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new ProcessDefsMonitor(agent);
        }
        return instance;
    }

    public void init() {
        try {
            if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                TibcoBWUtils.getLogger().debug("init  method");
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSDEFS, bomb);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getProcessDefsMetrics(obj);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSDEFS, bomb);
        }
    }

    private void getProcessDefsMetrics(Object methodObj) {
        try {
            TibcoBWUtils.getLogger().debug("ProcessDefsMonitor.getProcessDefsMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[1]);
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("ProcessDefs Size: " + size);
                int i = 0;
                while (i < size) {
                    this.forEach(i, result);
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSDEFS, bomb);
        }
    }

    private void forEach(int i, Object result) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String processName = null;
        int limit = 21;
        Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{i});
        if (param != null) {
            String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
            Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
            if (i % limit == 0) {
                processName = value.toString();
                if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.activities")) {
                    this.getActivitiesMetrics(processName);
                }
            }
            if (value != null) {
                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                this.reportMetric("ProcessDefs|" + processName, name, value.toString());
            } else {
                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                this.reportMetric("ProcessDefs|" + processName, name, "");
            }
        }
    }

    private void getActivitiesMetrics(String processName) {
        try {
            TibcoBWUtils.getLogger().debug("ProcessDefsMonitor.getActivitiesMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Class<?> amiParameter = Class.forName("COM.TIBCO.hawk.ami.AmiParameter", false, ClassLoader.getSystemClassLoader());
            Class[] stringArgClass = new Class[]{String.class, String.class, Object.class};
            Constructor<?> constAmiParameter = amiParameter.getConstructor(stringArgClass);
            Object[] amiElement = new Object[]{"ProcessDefName", "", processName};
            Object amiParObject = constAmiParameter.newInstance(amiElement);
            Constructor<?> constAmiParameterList = amiParameterList.getConstructor(null);
            Object amiParListObject = constAmiParameterList.newInstance(new Object[0]);
            TibcoBWUtils.invokeMethodOnObject(amiParListObject, "add", new Class[]{amiParameter}, new Object[]{amiParObject});
            Object result = TibcoBWUtils.invokeMethodOnObject(this.activitiesMethodObject, "onInvoke", new Class[]{amiParameterList}, new Object[]{amiParListObject});
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("ActivitiesMetric Size: " + size);
                int i = 1;
                while (i < size) {
                    this.forEach1(i, result, processName);
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_ACTIVITIES", bomb);
        }
    }

    private void forEach1(int i, Object result, String processName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String activityName = null;
        int limit = 18;
        Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{i});
        if (param != null) {
            String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
            Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
            if (i % limit == 1) {
                activityName = value.toString();
            }
            if (i % limit != 0) {
                if (value != null) {
                    TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                    this.reportActivityMetric("ProcessDefs|" + processName + "|" + activityName, name, value.toString());
                } else {
                    TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                    this.reportActivityMetric("ProcessDefs|" + processName + "|" + activityName, name, "");
                }
            }
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            if (name.equals(K_NAME) || name.equals(K_STARTER)) {
                this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
            } else {
                if (value == "") {
                    value = "0";
                }
                this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSDEFS, bomb);
        }
    }

    private void reportActivityMetric(String component, String name, String value) {
        try {
            if (name.equals(K_NAME) || name.equals(K_TRACING) || name.equals(K_LAST_RETURN_CODE) || name.equals(K_CALLED_PROCESS_DEFS) || name.equals(K_ACTIVITY_CLASS)) {
                this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
            } else {
                if (value == null) {
                    value = "0";
                }
                this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_ACTIVITIES", bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }

    public void registerActivitiesMethodObject(Object methodObj) {
        this.activitiesMethodObject = methodObj;
    }
}

