/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class ProcessesMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static ProcessesMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String COMP = "Processes";
    private static final String ERROR_IN_HAWKMONITOR_PROCESSES = "ERROR_IN_HAWKMONITOR_PROCESSES";

    public ProcessesMonitor(IAgent agent) {
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static ProcessesMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new ProcessesMonitor(agent);
        }
        return instance;
    }

    public void init() {
        try {
            if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                TibcoBWUtils.getLogger().debug("init method");
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSES, bomb);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getProcessesMetrics(obj);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSES, bomb);
        }
    }

    private void getProcessesMetrics(Object methodObj) {
        try {
            TibcoBWUtils.getLogger().debug("ProcessesMonitor.getProcessesMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object argument = TibcoBWUtils.invokeMethodOnObject(methodObj, "getArguments");
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[]{argument});
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("Processes Size: " + size);
                int i = 0;
                while (i < size) {
                    this.forEach(i, result);
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSES, bomb);
        }
    }

    private void forEach(int i, Object result) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String jobName = null;
        int limit = 11;
        Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{i});
        if (param != null) {
            String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
            Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
            if (i % limit == 1) {
                jobName = value.toString();
            }
            if (i % limit != 0) {
                if (value != null) {
                    TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                    this.reportMetric("Processes|" + jobName, name, value.toString());
                } else {
                    TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                    this.reportMetric("Processes|" + jobName, name, "0");
                }
            }
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_PROCESSES, bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }
}

