/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class ServiceInfosMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static ServiceInfosMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String COMP = "ServicesInfo";
    private static final String COMP_2 = "bindingName";
    private static final String ERROR_IN_HAWKMONITOR_SERVICEINFOS = "ERROR_IN_HAWKMONITOR_SERVICEINFOS";

    public ServiceInfosMonitor(IAgent agent) {
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static ServiceInfosMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new ServiceInfosMonitor(agent);
        }
        return instance;
    }

    public void init() {
        try {
            if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                TibcoBWUtils.getLogger().debug("init method");
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_SERVICEINFOS, bomb);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getServiceInfosMetrics(obj);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_SERVICEINFOS, bomb);
        }
    }

    private void getServiceInfosMetrics(Object methodObj) {
        try {
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[1]);
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("ServiceInfos Size: " + size);
                int i = 0;
                while (i < size) {
                    this.forEach(i, result);
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_SERVICEINFOS, bomb);
        }
    }

    private void forEach(int i, Object result) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String processName = null;
        int limit = 9;
        Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{i});
        if (param != null) {
            String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
            Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
            if (i % limit == 0) {
                processName = value.toString();
            }
            if (value != null) {
                if (name.equalsIgnoreCase(COMP_2)) {
                    name = "BindingName";
                }
                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                this.reportMetric("ServicesInfo|" + processName, name, value.toString());
            } else {
                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                this.reportMetric("ServicesInfo|" + processName, name, "");
            }
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_SERVICEINFOS, bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }
}

