/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class StatusMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static StatusMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String COMP = "Status";
    private static final String K_NEW_ERRORS = "New Errors";
    private static final String K_TOTAL_ERRORS = "Total Errors";
    private static final String K_UPTIME = "Uptime";
    private static final String ERROR_IN_HAWKMONITOR_STATUS = "ERROR_IN_HAWKMONITOR_STATUS";

    public StatusMonitor(IAgent agent) {
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static StatusMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new StatusMonitor(agent);
        }
        return instance;
    }

    public void init() {
        try {
            if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                TibcoBWUtils.getLogger().debug("init method");
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_STATUS, bomb);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getStatusMetrics(obj);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_STATUS, bomb);
        }
    }

    private void getStatusMetrics(Object methodObj) {
        try {
            TibcoBWUtils.getLogger().debug("StatusMonitor.getStatusMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[1]);
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("StatusMonitor Size: " + size);
                int i = 0;
                while (i < size) {
                    this.forEach(i, result);
                    ++i;
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_STATUS, bomb);
        }
    }

    private void forEach(int i, Object result) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String processName = null;
        Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{i});
        if (param != null) {
            String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
            Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
            if (i == 0) {
                processName = value.toString();
            }
            if (value != null) {
                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                this.reportMetric("Status|" + processName, name, value.toString());
            } else {
                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                this.reportMetric("Status|" + processName, name, "");
            }
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            if (name.equals(K_NEW_ERRORS) || name.equals(K_TOTAL_ERRORS) || name.equals(K_UPTIME)) {
                if (value == "") {
                    value = "0";
                }
                this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
            } else {
                this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.iAgent, ERROR_IN_HAWKMONITOR_STATUS, bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }
}

