/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.jms.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class JMSReceiveCorrelationTracer
extends BlamePointTracer {
    private static final Class[] STRINGCLASSARRAY = new Class[]{String.class};
    private static final String GET_STRING_PROPERTY = "getStringProperty";
    private static final Object[] EMPTYOBJECTARRAY = new Object[0];
    private static final String GET_MESSAGE = "getMessage";
    private static final Class[] EMPTYCLASSARRAY = new Class[0];
    private IModuleFeedbackChannel log;
    private static final Module sModule = new Module("Tibco JMS Receive Tracer");

    public JMSReceiveCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.log = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        super.ITracer_startTrace(tracerIndex, data);
        this.getComponentTracer().addExtraParameter("Normalized URL", data.getComponentName());
        this.getComponentTracer().setInURLTracingContext();
        if (TibcoBWUtils.correlationJMSReadEnabled()) {
            boolean result;
            Object eventContext = data.getInvocationParameterAsObject(0);
            Object messageObject = null;
            try {
                Method getMessageMethod = eventContext.getClass().getMethod(GET_MESSAGE, EMPTYCLASSARRAY);
                getMessageMethod.setAccessible(true);
                messageObject = getMessageMethod.invoke(eventContext, EMPTYOBJECTARRAY);
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
                this.log.error(sModule, "Error in addon jms correlation");
            }
            if (messageObject == null) {
                this.log.debug("No message Object found by JMS receive");
                return;
            }
            if (!this.readCorrelation(messageObject, "CorID") && !(result = this.readCorrelation(messageObject, "CorIDForSOAPInvocation"))) {
                this.getAgent().IAgent_getModuleFeedback().warn("No correlation ID found in inbound JMS message - JMS Receive Correlation");
            }
        }
    }

    private boolean readCorrelation(Object messageObject, String correlationKey) {
        try {
            Method getPropertyMethod = messageObject.getClass().getMethod(GET_STRING_PROPERTY, STRINGCLASSARRAY);
            getPropertyMethod.setAccessible(true);
            String uniqueId = (String)getPropertyMethod.invoke(messageObject, correlationKey);
            if (uniqueId != null && !uniqueId.trim().equals("")) {
                new CorrelationId(uniqueId);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            this.log.error(sModule, "Error in addon jms correlation");
        }
        return false;
    }
}

