/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.StringUtils;

public class BWGenericFormatter
implements INameFormatter {
    private final IAgent fAgent;

    public BWGenericFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public IAgent getAgent() {
        return this.fAgent;
    }

    public String getWebServiceURI(InvocationData data) {
        if (TibcoBWUtils.getLogger().isDebugEnabled()) {
            TibcoBWUtils.getLogger().debug(data.toString());
        }
        return "UnknownServiceName";
    }

    public String getOperationName(InvocationData data) {
        if (TibcoBWUtils.getLogger().isDebugEnabled()) {
            TibcoBWUtils.getLogger().debug(data.toString());
        }
        return "UnknownOperationName";
    }

    public String getNamespace(InvocationData data) {
        TibcoBWUtils.getLogger().debug(data.toString());
        return "UnknownNamespace";
    }

    public String INameFormatter_format(String name, InvocationData data) {
        if (name != null) {
            name = this.duringNameExist(name, data);
        }
        return name;
    }

    private String duringNameExist(String name, InvocationData data) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        name = this.nameSpaceExist(name, data, isDebugEnabled);
        name = this.serviceExist(name, data, isDebugEnabled);
        name = this.operationExist(name, data, isDebugEnabled);
        return name;
    }

    private String operationExist(String name, InvocationData data, boolean isDebugEnabled) {
        String operationName = null;
        if (name.indexOf("{operationname}", 0) >= 0) {
            operationName = (String)data.get("com.wily.soaextension.tibcobw.OperationNameKey");
            if ((operationName == null || operationName.equals("UnknownOperationName")) && (operationName = this.getOperationName(data)) == null) {
                return "UnknownOperationName";
            }
            operationName = TibcoBWUtils.formatToBeResourceSafe(operationName);
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("Found OperationName: " + operationName);
            }
            data.put("com.wily.soaextension.tibcobw.OperationNameKey", (Object)operationName);
            name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
        }
        return name;
    }

    private String serviceExist(String name, InvocationData data, boolean isDebugEnabled) {
        String webServiceURI = null;
        if (name.indexOf("{servicename}", 0) >= 0) {
            webServiceURI = (String)data.get("com.wily.soaextension.tibcobw.ServiceNameKey");
            if ((webServiceURI == null || webServiceURI.equals("UnknownServiceName")) && (webServiceURI = this.getWebServiceURI(data)) == null) {
                return "UnknownServiceName";
            }
            webServiceURI = TibcoBWUtils.formatToBeResourceSafe(webServiceURI);
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("Found WebService URI: " + webServiceURI);
            }
            data.put("com.wily.soaextension.tibcobw.ServiceNameKey", (Object)webServiceURI);
            name = StringUtils.replace((String)name, (String)"{servicename}", (String)webServiceURI);
        }
        return name;
    }

    private String nameSpaceExist(String name, InvocationData data, boolean isDebugEnabled) {
        String namespace = null;
        if (name.indexOf("{namespace}", 0) >= 0) {
            namespace = (String)data.get("com.wily.soaextension.tibcobw.NamespaceKey");
            if ((namespace == null || namespace.equals("UnknownNamespace")) && (namespace = this.getNamespace(data)) == null) {
                return "UnknownNamespace";
            }
            namespace = TibcoBWUtils.formatToBeResourceSafe(namespace);
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("Found Namespace: " + namespace);
            }
            data.put("com.wily.soaextension.tibcobw.NamespaceKey", (Object)namespace);
            name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
        }
        return name;
    }
}

