/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.naming;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.environment.IAppserverEnvironmentInfoCallback;
import com.wily.soaextension.tibcobw.naming.BWNameService;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BWAgentNamer
implements ITimestampedRunnable,
IAppserverEnvironmentInfoCallback {
    private final IAgent agent;
    private boolean agentNameFound = false;
    Module module;
    String newAgentName = "";
    private static final String C_ENGINE = "com.tibco.pe.core.Engine";
    private static final String F_PROPS = "props";
    private static final String M_GETSTRING = "getString";
    private static final String P_NAME = "name";
    private static final String P_DOMAIN = "tibco.domain";
    private static final String P_DEPLOYMENT = "tibco.deployment";
    private static final String SEPARATOR = "_";

    public BWAgentNamer(IAgent agent) {
        this.agent = agent;
        this.module = new Module("TibcoBW");
    }

    public void ITimestampedRunnable_execute(long arg0) {
        String domainName = null;
        String argumentName = null;
        String deploymentName = null;
        if (!this.agentNameFound || BWNameService.getTibcoNameBehavior() == null) {
            try {
                Class<?> engineClass = Class.forName(C_ENGINE, false, ClassLoader.getSystemClassLoader());
                if (engineClass == null) {
                    this.agent.IAgent_getModuleFeedback().debug(this.module, "Waiting for engile class initialization");
                    return;
                }
                Field enginePropertiesField = engineClass.getField(F_PROPS);
                enginePropertiesField.setAccessible(true);
                Object engineProperties = enginePropertiesField.get(null);
                if (engineProperties == null) {
                    this.agent.IAgent_getModuleFeedback().info(this.module, "Not getting tibco engine properties");
                    return;
                }
                Method getProperyMethod = engineProperties.getClass().getMethod(M_GETSTRING, String.class);
                domainName = this.extractDomainName(engineProperties, getProperyMethod);
                StringBuilder buff = new StringBuilder();
                buff.append(domainName == null ? "" : domainName);
                argumentName = this.extractNameArgument(engineProperties, getProperyMethod);
                deploymentName = this.extractDeploymentName(engineProperties, getProperyMethod);
                this.duringArgNotNull(argumentName, buff, deploymentName);
                this.newAgentName = buff.toString();
                this.agentNameFound = true;
                this.agent.IAgent_getModuleFeedback().debug(this.module, "BWAgentNamer - Agent Name Found :" + this.newAgentName);
            }
            catch (Exception bomb) {
                this.agent.IAgent_getModuleFeedback().error(this.module, "BWAgentNamer - Error in BW deployment", (Throwable)bomb);
            }
        } else {
            this.agent.IAgent_getCommonHeartbeat().removeBehavior(BWNameService.getTibcoNameBehavior());
        }
    }

    private void duringArgNotNull(String argumentName, StringBuilder buff, String deploymentName) {
        if (argumentName != null) {
            buff.append(buff.length() > 0 ? SEPARATOR : "");
            buff.append(argumentName);
        } else if (deploymentName != null) {
            buff.append(buff.length() > 0 ? SEPARATOR : "");
            buff.append(deploymentName);
        }
    }

    public String IAppserverEnvironmentInfoCallback_getAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        this.agent.IAgent_getModuleFeedback().debug(this.module, "BWAgentNamer.getAgentName: " + this.newAgentName);
        return this.newAgentName;
    }

    private String extractNameArgument(Object engineProperties, Method getProperyMethod) throws IllegalAccessException, InvocationTargetException {
        return (String)getProperyMethod.invoke(engineProperties, P_NAME);
    }

    private String extractDeploymentName(Object engineProperties, Method getProperyMethod) throws IllegalAccessException, InvocationTargetException {
        return (String)getProperyMethod.invoke(engineProperties, P_DEPLOYMENT);
    }

    private String extractDomainName(Object engineProperties, Method getProperyMethod) throws IllegalAccessException, InvocationTargetException {
        return (String)getProperyMethod.invoke(engineProperties, P_DOMAIN);
    }
}

