/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer;

import com.wily.EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.tibcobw.processes.tracer.JobThreadlocal;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoPPException;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class JobCourierTracerEnhanced
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    private static final String TRACER_NAME = "JobCourierTracerEnanced: ";
    private boolean showRunningMetric = false;
    static final CopyOnWriteArraySet kStaticRepository = new CopyOnWriteArraySet();

    public JobCourierTracerEnhanced(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.setParameterCallback((IInvocationDataParameterCallback)this);
        super.ITracer_startTrace(tracerIndex, data);
    }

    private String getCustomConcurrentMetricName(String componentName) {
        return componentName + ":Concurrent Invocations";
    }

    private String getCustomARTMetricName(String componentName) {
        return componentName + ":Average Response Time (ms)";
    }

    private String getCustomRPIMetricName(String componentName) {
        return componentName + ":Responses Per Interval";
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation info) {
        AgentMetric[] runningConcurrentMetric;
        String param = this.getParameter("showRunningMetric");
        if (param != null) {
            this.showRunningMetric = Boolean.parseBoolean(param);
        }
        HashMap<IRepository, AgentMetric[]> metrics = new HashMap<IRepository, AgentMetric[]>(8);
        IRepository runningConcurrentSds = null;
        IRepository runningExistingSds = null;
        IRepository runningTimerSds = null;
        IRepository runningPerIntervalSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository timerSds = null;
        IRepository perIntervalSds = null;
        IRepository concurrentSds = null;
        IRepository existingConcurrentSd = null;
        TibcoBWUtils.getLogger().debug("jobCourierTracerEnhanced showRunningMetric is " + this.showRunningMetric);
        if (this.showRunningMetric && (runningExistingSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(runningConcurrentMetric = this.createConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(componentName))), (IRepository)(runningConcurrentSds = this.getSharedRepositoryNoSharedStructure(false)))) != null) {
            runningConcurrentSds = runningExistingSds;
        }
        if (this.showRunningMetric) {
            AgentMetric[] runningTimerMetric = this.createTimerMetric(this.getTimerMetricName(componentName));
            runningTimerSds = BlamePointTracer.getAverageMetricRepository();
            metrics.put(runningTimerSds, runningTimerMetric);
        }
        if (this.showRunningMetric) {
            AgentMetric[] runningPerIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(componentName));
            runningPerIntervalSds = BlamePointTracer.getCountQueuedRepository((boolean)true);
            metrics.put(runningPerIntervalSds, runningPerIntervalMetric);
        }
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] stallMetric = this.createStallsMetric(this.getStallsMetricName(componentName));
            stallSds = this.getSharedRepositoryNoSharedStructure(false);
            metrics.put(stallSds, stallMetric);
            AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(componentName));
            errorsSds = BlamePointTracer.getCountQueuedRepository((boolean)true);
            metrics.put(errorsSds, errorMetric);
        }
        AgentMetric[] timerMetric = this.createAdditionalTimerMetric(this.getCustomARTMetricName(componentName));
        timerSds = BlamePointTracer.getAverageMetricRepository();
        metrics.put(timerSds, timerMetric);
        AgentMetric[] perIntervalMetric = this.createAdditionalPerIntervalMetric(this.getCustomRPIMetricName(componentName));
        perIntervalSds = BlamePointTracer.getCountQueuedRepository((boolean)true);
        metrics.put(perIntervalSds, perIntervalMetric);
        AgentMetric[] concurrentMetric = this.createAdditionalConcurrentInvocationMetric(this.getCustomConcurrentMetricName(componentName));
        concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
        existingConcurrentSd = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(concurrentMetric), (IRepository)concurrentSds);
        if (existingConcurrentSd != null) {
            concurrentSds = existingConcurrentSd;
        }
        CustomWilyTransactionElement result = null;
        result = this.showRunningMetric ? new CustomWilyTransactionElement(key, componentName, this.getBlameStatus(), true, parent, previous, null, metrics, runningTimerSds, runningPerIntervalSds, runningConcurrentSds, errorsSds, stallSds, info, timerSds, perIntervalSds, concurrentSds) : new CustomWilyTransactionElement(key, componentName, this.getBlameStatus(), true, parent, previous, null, metrics, null, null, null, null, null, info, timerSds, perIntervalSds, concurrentSds);
        return result;
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement wte, InvocationData data, int index) {
        int hashcode = data.hashCode();
        String componentname = data.getComponentNameAt(index);
        TibcoBWUtils.getLogger().debug("ENd of thread " + componentname);
        if (JobThreadlocal.isEnd()) {
            Object createdJobObject = data.getInvocationParameterAsObject(0);
            CustomWilyTransactionElement customWilyTransactionElement = (CustomWilyTransactionElement)wte;
            HashMap variablesMap = null;
            variablesMap = (HashMap)this.getCtx(data, createdJobObject);
            if (variablesMap != null && variablesMap.containsKey("com.wily.soaextension.tibcobw.BPstarttimeKey")) {
                IRepository cin;
                IRepository customPerIntervalSds;
                String startTime = (String)variablesMap.get("com.wily.soaextension.tibcobw.BPstarttimeKey");
                long startedTime = Long.parseLong(startTime);
                long endTime = data.getWallClockFinishTime();
                long elapsedTime = endTime - startedTime;
                IRepository customTimerSds = customWilyTransactionElement.getCustomTimerSds();
                if (customTimerSds != null) {
                    customTimerSds.update(BlamePointTracer.getUpdater(), elapsedTime, startedTime, endTime);
                }
                if ((customPerIntervalSds = customWilyTransactionElement.getCustomPerIntervalSds()) != null) {
                    customPerIntervalSds.update(BlamePointTracer.getIncreaser(), 0L, startedTime, endTime);
                }
                if ((cin = customWilyTransactionElement.getCustomConcurrentSds()) != null) {
                    cin.update(BlamePointTracer.getDecreaser(), 0L, endTime, hashcode);
                }
                JobThreadlocal.removeEndTh();
            }
        }
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        super.doOnEndTrace(tracerIndex, elementData, element);
        if (data.hasInvocationThrownException()) {
            String componentname = data.getComponentNameAt(tracerIndex);
            Throwable error = null;
            String errorMessage = null;
            error = data.getInvocationThrownException();
            errorMessage = String.valueOf(componentname) + error.getMessage();
            ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
            ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
            ErrorFeature.incrementErrorMetric((IStackElement)data);
        }
        WilyTransactionElement we = (WilyTransactionElement)element;
        WilyTransactionElement start = (WilyTransactionElement)we.getStartTraceBlamePoint();
        this.updateCustomMetricsIfAny(start, data, tracerIndex);
        this.consumeComponentId(data);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map params) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        String businessProcessName = (String)data.get("com.wily.soaextension.tibcobw.ProcessNameKey");
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("JobCourierTracer: ProcessName for SOA TT Filter = " + businessProcessName);
        }
        if (businessProcessName != null && businessProcessName.length() > 0) {
            params.put("businessprocess", businessProcessName);
        }
    }

    public Map getCtx(InvocationData data, Object createdJobObject) {
        HashMap variablesMap;
        block2: {
            variablesMap = null;
            Object variablesMapobj = data.get("Context_M");
            try {
                variablesMap = variablesMapobj == null ? this.getJobHashMap(createdJobObject) : (HashMap)variablesMapobj;
            }
            catch (Exception e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
        return variablesMap;
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        block5: {
            WilyTransactionElement wte = (WilyTransactionElement)element;
            InvocationData data = (InvocationData)elementData;
            int hashcode = data.hashCode();
            Object createdJobObject = data.getInvocationParameterAsObject(0);
            boolean bpStartTimeKeyNotExists = false;
            Map map = this.getJobsMap(data, createdJobObject, wte.isStartTrace());
            if (map != null) {
                bpStartTimeKeyNotExists = !map.containsKey("com.wily.soaextension.tibcobw.BPstarttimeKey");
            }
            long startTime = data.getWallClockStartTime();
            if (bpStartTimeKeyNotExists) {
                IRepository cin;
                map.put("com.wily.soaextension.tibcobw.BPstarttimeKey", String.valueOf(startTime));
                if (wte instanceof CustomWilyTransactionElement && (cin = ((CustomWilyTransactionElement)wte).getCustomConcurrentSds()) != null) {
                    cin.update(BlamePointTracer.getIncreaser(), 0L, startTime, hashcode);
                }
                try {
                    this.setJobHashMap(createdJobObject, (HashMap)map);
                }
                catch (TibcoPPException e) {
                    if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block5;
                    TibcoBWUtils.getLogger().debug(e.getMessage());
                }
            }
        }
        super.doOnStartTrace(tracerIndex, elementData, element);
    }

    private Map getJobsMap(InvocationData data, Object jobObject, boolean startTrace) {
        HashMap variablesMap;
        block5: {
            variablesMap = null;
            try {
                if (startTrace) {
                    variablesMap = this.getJobHashMap(jobObject);
                    if (variablesMap == null) {
                        variablesMap = new HashMap();
                    }
                    data.put("Context_M", (Object)variablesMap);
                } else {
                    variablesMap = this.getCtx(data, jobObject);
                }
            }
            catch (TibcoPPException e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block5;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
        return variablesMap;
    }

    private HashMap getJobHashMap(Object createdJobObject) throws TibcoPPException {
        HashMap variablesMap = null;
        try {
            variablesMap = (HashMap)TibcoReflectionCache.getFJobM(createdJobObject).get(createdJobObject);
        }
        catch (Exception e) {
            throw new TibcoPPException(TRACER_NAME, e.getMessage());
        }
        return variablesMap;
    }

    private void setJobHashMap(Object createdJobObject, HashMap variablesMap) throws TibcoPPException {
        try {
            TibcoReflectionCache.getFJobM(createdJobObject).set(createdJobObject, variablesMap);
        }
        catch (Exception e) {
            throw new TibcoPPException(TRACER_NAME, e.getMessage());
        }
    }

    protected long getFilterEnablerBit() {
        return 8L;
    }

    protected Object getBlameKey(InvocationData data) {
        return ABlameComponent.getInstance((Object)this.getComponentName(data));
    }

    private static class CustomWilyTransactionElement
    extends WilyTransactionElement {
        private IRepository customTimerSds = null;
        private IRepository customPerIntervalSds = null;
        private IRepository customConcurrentSds = null;

        public CustomWilyTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation info, IRepository customTimerSds, IRepository customPerIntervalSds, IRepository customConcurrentSds) {
            super(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, fTimerDataStructure, fPerIntervalDataStructure, fConcurrentInvocationDataStructure, fErrorsDataStructure, fStallsDataStructure, info, false, false);
            this.customTimerSds = customTimerSds;
            this.customPerIntervalSds = customPerIntervalSds;
            this.customConcurrentSds = customConcurrentSds;
        }

        public IRepository getCustomTimerSds() {
            return this.customTimerSds;
        }

        public IRepository getCustomPerIntervalSds() {
            return this.customPerIntervalSds;
        }

        public IRepository getCustomConcurrentSds() {
            return this.customConcurrentSds;
        }
    }
}

