/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoPPException;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class SubprocessStartTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    private static final String TRACER_NAME = "SubprocessStartTracer: ";

    private HashMap getJobHashMap(Object createdJobObject) throws TibcoPPException {
        HashMap variablesMap = null;
        try {
            variablesMap = (HashMap)TibcoReflectionCache.getFJobM(createdJobObject).get(createdJobObject);
        }
        catch (Exception e) {
            throw new TibcoPPException(TRACER_NAME, e.getMessage());
        }
        return variablesMap;
    }

    private void setJobHashMap(Object createdJobObject, HashMap variablesMap) throws TibcoPPException {
        try {
            TibcoReflectionCache.getFJobM(createdJobObject).set(createdJobObject, variablesMap);
        }
        catch (Exception e) {
            throw new TibcoPPException(TRACER_NAME, e.getMessage());
        }
    }

    public SubprocessStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected void updateCustomMetricsIfAnywithTracerIndex(WilyTransactionElement wte, InvocationData data, int index) {
        block4: {
            String component = data.getComponentNameAt(index);
            Object objparentJob = data.getInvocationObject();
            try {
                HashMap<String, String> variablesMap = this.getJobHashMap(objparentJob);
                if (variablesMap == null) {
                    variablesMap = new HashMap<String, String>();
                }
                if (!variablesMap.containsKey(component)) {
                    long sttime = data.getWallClockFinishTime();
                    variablesMap.put(component, String.valueOf(sttime));
                    this.setJobHashMap(objparentJob, variablesMap);
                }
                TibcoReflectionCache.increamentCICount(component);
            }
            catch (TibcoPPException e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block4;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setStartCursorAt(element, tracerIndex);
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        WilyTransactionElement we = (WilyTransactionElement)element;
        InvocationData data = (InvocationData)elementData;
        WilyTransactionElement start = (WilyTransactionElement)we.getStartTraceBlamePoint();
        this.updateCustomMetricsIfAnywithTracerIndex(start, data, tracerIndex);
    }

    public void ITracer_startTrace(int i, InvocationData invocationdata) {
        invocationdata.setParameterCallback((IInvocationDataParameterCallback)this);
        super.ITracer_startTrace(i, invocationdata);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map params) {
        String businessProcessName = (String)data.get("com.wily.soaextension.tibcobw.SubprocessNameKey");
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("SubprocessStartTracer: ProcessName for SOA TT Filter = " + businessProcessName);
        }
        if (businessProcessName != null && businessProcessName.length() > 0) {
            params.put("businessprocess", businessProcessName);
        }
    }

    protected long getFilterEnablerBit() {
        return 8L;
    }
}

