/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.rv.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RVQAndQueueGroupMonitor
implements ITimestampedRunnable {
    private final IAgent fAgent;
    private static RVQAndQueueGroupMonitor sInstance = null;
    private DataAccumulatorFactory fDataAccumulatorFactory = null;
    private List fMonitorPool = new ArrayList();
    private Class fQueueType = null;
    private Class fQueueGroupType = null;
    private Field queueGroupField = null;
    private static final Object lock = new Object();

    private void init() {
        block5: {
            block4: {
                try {
                    this.fQueueType = Class.forName("com.tibco.tibrv.TibrvQueue", false, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException e) {
                    if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block4;
                    TibcoBWUtils.getLogger().debug(e.getMessage());
                }
            }
            try {
                this.fQueueGroupType = Class.forName("com.tibco.tibrv.TibrvQueueGroup", false, ClassLoader.getSystemClassLoader());
                this.assignQueueGroupField();
            }
            catch (ClassNotFoundException e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block5;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
    }

    private void assignQueueGroupField() {
        block4: {
            try {
                this.queueGroupField = this.fQueueGroupType.getDeclaredField(KConstants.KF_TIBRVQUEUEGROUP_QUEUES);
                this.queueGroupField.setAccessible(true);
            }
            catch (SecurityException e) {
                if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                    TibcoBWUtils.getLogger().debug("SecurityException " + e.getMessage());
                }
            }
            catch (NoSuchFieldException e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block4;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
    }

    private RVQAndQueueGroupMonitor(IAgent agent) {
        this.fAgent = agent;
        this.fDataAccumulatorFactory = this.fAgent.IAgent_getDataAccumulatorFactory();
        this.init();
    }

    public static RVQAndQueueGroupMonitor getInstance(IAgent agent) {
        if (sInstance == null) {
            sInstance = new RVQAndQueueGroupMonitor(agent);
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITimestampedRunnable_execute(long l) {
        Object object = lock;
        synchronized (object) {
            try {
                for (Object obj : this.fMonitorPool) {
                    if (obj.getClass().equals(this.fQueueType)) {
                        this.reportQueueMetric(obj, "Tibco|Transports|RV|Queues|");
                    }
                    if (!obj.getClass().equals(this.fQueueGroupType)) continue;
                    this.reportQueueGroupMetric(obj, "Tibco|Transports|RV|Queue Groups|");
                }
            }
            catch (Exception bomb) {
                TibcoBWUtils.handleError(this.fAgent, "Error while monitoring Queue", bomb);
            }
        }
    }

    private int getCurrentEventFromQueue(Object queueObject) {
        int currentEvents;
        block2: {
            currentEvents = 0;
            try {
                currentEvents = (Integer)TibcoBWUtils.invokeMethodOnObject(queueObject, KConstants.KM_TIBRVQUEUE_GETCOUNT);
            }
            catch (Exception e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
        return currentEvents;
    }

    private int getDiscardedEventFromQueue(Object queueObject) {
        int discardedEvents;
        block2: {
            discardedEvents = 0;
            try {
                discardedEvents = (Integer)TibcoBWUtils.invokeMethodOnObject(queueObject, KConstants.KM_TIBRVQUEUE_GETDISCARDAMOUNT);
            }
            catch (Exception e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
        return discardedEvents;
    }

    private int getMaxEventFromQueue(Object queueObject) {
        int maxEvents;
        block2: {
            maxEvents = 0;
            try {
                maxEvents = (Integer)TibcoBWUtils.invokeMethodOnObject(queueObject, KConstants.KM_TIBRVQUEUE_GETMAXEVENTS);
            }
            catch (Exception e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
        return maxEvents;
    }

    private void reportQueueMetric(Object queueObject, String metricPath) {
        block2: {
            String queueName = "UnknownQueue";
            try {
                queueName = (String)TibcoBWUtils.invokeMethodOnObject(queueObject, KConstants.KM_TIBRVQUEUE_GETNAME);
                StringBuilder queueMetricPath = new StringBuilder(metricPath);
                queueMetricPath.append(queueName);
                queueMetricPath.append(":");
                this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueMetricPath + "Current Events").IIntegerAggregatingDataAccumulator_recordDataPoint(this.getCurrentEventFromQueue(queueObject));
                this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueMetricPath + "Maximum Events").IIntegerAggregatingDataAccumulator_recordDataPoint(this.getDiscardedEventFromQueue(queueObject));
                this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueMetricPath + "Discarded Events").IIntegerAggregatingDataAccumulator_recordDataPoint(this.getMaxEventFromQueue(queueObject));
            }
            catch (Exception e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
    }

    private void reportQueueGroupMetric(Object queueGroupObject, String metricPath) {
        block3: {
            int totalCurrentEvents = 0;
            int totalDiscardedEvents = 0;
            try {
                StringBuilder queueGroupMetricPath = new StringBuilder(metricPath);
                queueGroupMetricPath.append("TibrvQueueGroup");
                queueGroupMetricPath.append(":");
                Vector queueGroup = (Vector)this.queueGroupField.get(queueGroupObject);
                for (Object queueObject : queueGroup) {
                    totalCurrentEvents += this.getCurrentEventFromQueue(queueObject);
                    totalDiscardedEvents += this.getDiscardedEventFromQueue(queueObject);
                }
                this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueGroupMetricPath + "Total Current Events").IIntegerAggregatingDataAccumulator_recordDataPoint(totalCurrentEvents);
                this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueGroupMetricPath + "Total Discarded Events").IIntegerAggregatingDataAccumulator_recordDataPoint(totalDiscardedEvents);
            }
            catch (Exception e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block3;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerItem(Object queueObj) {
        Object object = lock;
        synchronized (object) {
            TibcoBWUtils.getLogger().debug("Registering Object");
            this.fMonitorPool.add(queueObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterItem(Object queueObj) {
        Object object = lock;
        synchronized (object) {
            TibcoBWUtils.getLogger().debug("Deregistering Object");
            this.fMonitorPool.remove(queueObj);
        }
    }
}

