/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.transport.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.soaextension.tibcobw.transport.tracer.RequestParameterContainer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.util.Map;

public class RequestExecuterCreationTracer
extends BlamePointTracer {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String GET_FIELD_MAP = "getFieldMap";
    private static final String TRANSPORT_CONTEXT_CLASS = "com.tibco.xml.soap.impl.transport.JakartaTransportContext";
    private IModuleFeedbackChannel log;
    private static Module sModule = new Module("Tibco Request Executer Tracer");
    private static int transportContextPosition;
    private static boolean transportContextPositionFound;
    private static Method getFieldMapMethod;
    public static final String ID_QUALIFIER = "WilyTraceID";

    static {
        transportContextPositionFound = false;
    }

    private static void setTransportContextPosition(int transportContextPosition) {
        RequestExecuterCreationTracer.transportContextPosition = transportContextPosition;
    }

    private static void setTransportContextPositionFound(boolean transportContextPositionFound) {
        RequestExecuterCreationTracer.transportContextPositionFound = transportContextPositionFound;
    }

    private static Method getGetFieldMapMethod() {
        return getFieldMapMethod;
    }

    private static void setGetFieldMapMethod(Method getFieldMapMethod) {
        RequestExecuterCreationTracer.getFieldMapMethod = getFieldMapMethod;
    }

    public RequestExecuterCreationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object object) {
        super(agent, attributeListing, probeIdentification, object);
        this.log = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData invocationData) {
        super.ITracer_startTrace(tracerIndex, invocationData);
        Object jakartaTransportContextObject = null;
        if (!transportContextPositionFound) {
            this.findTransportContextParameter(invocationData);
        }
        if ((jakartaTransportContextObject = invocationData.getInvocationParameterAsObject(transportContextPosition)) != null) {
            if (RequestExecuterCreationTracer.getGetFieldMapMethod() == null) {
                try {
                    RequestExecuterCreationTracer.setGetFieldMapMethod(jakartaTransportContextObject.getClass().getMethod(GET_FIELD_MAP, EMPTY_CLASS_ARRAY));
                    getFieldMapMethod.setAccessible(true);
                }
                catch (Exception e) {
                    this.log.error((Throwable)e);
                    this.log.error(sModule, "Code Problem... extracting fieldmap failed");
                    return;
                }
            }
            String correlationId = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            try {
                Map fieldMap = (Map)getFieldMapMethod.invoke(jakartaTransportContextObject, EMPTY_OBJECT_ARRAY);
                fieldMap.put(ID_QUALIFIER, correlationId);
                Map<String, String> parameters = RequestParameterContainer.get();
                if (parameters != null && !parameters.isEmpty()) {
                    if (this.getModuleFeedback().isDebugEnabled()) {
                        this.getModuleFeedback().debug("Injecting in new Thread - CorrelationID: " + this.getComponentTracer().getCrossProcessDataCache().getCorrelationID() + "; Parameters: " + parameters + "; Thread: " + Thread.currentThread().getId());
                    }
                    fieldMap.putAll(parameters);
                    RequestParameterContainer.reset();
                }
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
                this.log.error(sModule, "Error at injecting correlationId");
            }
        }
    }

    private void findTransportContextParameter(InvocationData data) {
        int i = 0;
        while (i < data.getInvocationParameterCount()) {
            if (data.getInvocationParameterAsObject(i).getClass().getName().equals(TRANSPORT_CONTEXT_CLASS)) {
                RequestExecuterCreationTracer.setTransportContextPosition(i);
                RequestExecuterCreationTracer.setTransportContextPositionFound(true);
                break;
            }
            ++i;
        }
    }
}

