/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.util.feedback.Module;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BWObfuscationHelper {
    private HashMap<String, String> obfuscationMap;
    private static BWObfuscationHelper sInstance;
    static boolean unitFlag;
    private static boolean isContainer;
    private IAgent fAgent;
    private Module sModule;

    static {
        unitFlag = false;
        isContainer = false;
    }

    public static boolean isUnitFlag() {
        return unitFlag;
    }

    public static void setUnitFlag(boolean unitFlag) {
        BWObfuscationHelper.unitFlag = unitFlag;
    }

    public static boolean isContainer() {
        return isContainer;
    }

    public static void setContainer(boolean isContainer) {
        BWObfuscationHelper.isContainer = isContainer;
    }

    private BWObfuscationHelper() {
        block2: {
            this.obfuscationMap = new HashMap();
            this.sModule = new Module("TibcoBW");
            try {
                this.fAgent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException e) {
                if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                TibcoBWUtils.getLogger().debug(e.getMessage());
            }
        }
        this.initializeMap();
    }

    public static BWObfuscationHelper getInstance() {
        if (sInstance == null) {
            sInstance = new BWObfuscationHelper();
        }
        return sInstance;
    }

    public Map<String, String> getMap() {
        return this.obfuscationMap;
    }

    private void initializeMap() {
        block13: {
            InputStream is = null;
            try {
                try {
                    is = !unitFlag ? this.getClass().getResourceAsStream("/mapping.xml") : this.getClass().getResourceAsStream("/UnitTestMapping.xml");
                    if (is != null) {
                        this.readMappingFileAsStream(is);
                        break block13;
                    }
                    this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Mapping file input Stream is null.");
                }
                catch (Exception e) {
                    this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "An Error occured " + e.toString());
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        this.fAgent.IAgent_getModuleFeedback().verbose(this.sModule, "An Error occured while closing IO stream " + e2.toString());
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.fAgent.IAgent_getModuleFeedback().verbose(this.sModule, "An Error occured while closing IO stream " + e.toString());
                    }
                }
            }
        }
    }

    public String getTBWVersion() {
        String bwVersion = null;
        try {
            Class bwVersionClass = this.getBwVersionClass();
            Field versionField = bwVersionClass.getField("version");
            bwVersion = (String)versionField.get(bwVersionClass);
            if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Tibco BusinessWorks Version is: " + bwVersion);
            }
        }
        catch (Exception exception) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Exception while getting BW version");
        }
        return bwVersion;
    }

    private Class getBwVersionClass() throws ClassNotFoundException {
        Class<?> bwVersionClass = null;
        try {
            bwVersionClass = Class.forName("com.tibco.pe.PEVersion", false, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bwVersionClass = Class.forName("com.tibco.bw.container.BWContainerVersion", false, ClassLoader.getSystemClassLoader());
            BWObfuscationHelper.setContainer(true);
        }
        return bwVersionClass;
    }

    public String getTibRVVersion() {
        Class<?> rvVersionClass = null;
        String rvVersion = null;
        try {
            rvVersionClass = Class.forName("com.tibco.tibrv.Tibrv", false, ClassLoader.getSystemClassLoader());
            Field fVersion = rvVersionClass.getDeclaredField("VERSION_STRING");
            fVersion.setAccessible(true);
            rvVersion = (String)fVersion.get(rvVersionClass);
            if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Tibco Rendezvous Version is: " + rvVersion);
            }
        }
        catch (Exception exception) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Exception while getting RV version");
        }
        return rvVersion;
    }

    private Document parseMappingFileAsStream(InputStream is) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            return factory.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error(this.sModule, "Exception while reading mapping file. " + e.toString());
            return null;
        }
    }

    private void readMappingFileAsStream(InputStream is) {
        Document doc = this.parseMappingFileAsStream(is);
        if (doc != null) {
            this.loadCommonNames(doc);
            this.loadSpecifiedNames(doc);
        }
    }

    private void loadCommonNames(Document doc) {
        NodeList list = doc.getElementsByTagName("CommonNames");
        Node childNode = list.item(0);
        list = childNode.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node item = list.item(i);
            if (item instanceof Element) {
                if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Common item key is: " + item.getNodeName());
                    this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Common item value is: " + ((Element)item).getAttribute("name"));
                }
                this.obfuscationMap.put(item.getNodeName(), ((Element)item).getAttribute("name"));
            }
            ++i;
        }
    }

    private void loadSpecifiedNames(Document doc) {
        NodeList versionList = doc.getElementsByTagName("TBW");
        int i = 0;
        while (i < versionList.getLength()) {
            Node item = versionList.item(i);
            this.forEachVersion(item);
            ++i;
        }
    }

    private void forEachVersion(Node item) {
        if (item instanceof Element && this.getTBWVersion().equalsIgnoreCase(((Element)item).getAttribute("version"))) {
            NodeList newlist = item.getChildNodes();
            int j = 0;
            while (j < newlist.getLength()) {
                Node newitem = newlist.item(j);
                if (newitem instanceof Element) {
                    if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Special item key is: " + newitem.getNodeName());
                        this.fAgent.IAgent_getModuleFeedback().debug(this.sModule, "Special item value is: " + ((Element)newitem).getAttribute("name"));
                    }
                    this.obfuscationMap.put(newitem.getNodeName(), ((Element)newitem).getAttribute("name"));
                }
                ++j;
            }
        }
    }
}

