/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.util;

import com.wily.introscope.agent.trace.cas.ITransactionElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class FrontendCacheManager {
    private static final FrontendCacheManager INSTANCE = new FrontendCacheManager();
    private ConcurrentHashMap<String, FrontEndCacheObject> fFrontEndCache = null;
    private final AtomicInteger fErrCount = new AtomicInteger(0);

    private FrontendCacheManager() {
        this.fFrontEndCache = new ConcurrentHashMap();
    }

    public static FrontendCacheManager getInstance() {
        return INSTANCE;
    }

    public boolean isFrontendAvailable(String correlationID) {
        boolean result = false;
        if (this.fFrontEndCache.containsKey(correlationID)) {
            return true;
        }
        return result;
    }

    public void addFrontend(String id, ITransactionElement fFrontEndComponent) {
        if (id != null) {
            if (!this.fFrontEndCache.containsKey(id)) {
                FrontEndCacheObject cacheObjprev = null;
                FrontEndCacheObject value = null;
                value = new FrontEndCacheObject(fFrontEndComponent);
                cacheObjprev = this.fFrontEndCache.putIfAbsent(id, value);
                if (cacheObjprev != null) {
                    this.fFrontEndCache.get(id).incrementProcessCount();
                }
            } else {
                this.fFrontEndCache.get(id).incrementProcessCount();
            }
        }
    }

    public void removeFrontend(String id) {
        if (id != null && this.fFrontEndCache.containsKey(id)) {
            FrontEndCacheObject cacheObjprev = this.fFrontEndCache.get(id);
            try {
                if (cacheObjprev.decrementProcessCount() == 0) {
                    this.fFrontEndCache.remove(id);
                }
            }
            catch (Exception exception) {}
        }
    }

    public ITransactionElement getFrontend(String id) {
        if (id != null && this.fFrontEndCache.containsKey(id)) {
            FrontEndCacheObject cacheObjprev = this.fFrontEndCache.get(id);
            try {
                if (cacheObjprev != null) {
                    return cacheObjprev.getFrondEndTxEle();
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public int getFrontendErrorCount() {
        return this.fErrCount.get();
    }

    public void noteFrontendError() {
        this.fErrCount.incrementAndGet();
    }

    public int size() {
        return this.fFrontEndCache.size();
    }

    private class FrontEndCacheObject {
        volatile ITransactionElement fFrondEndTxEle;
        AtomicInteger fProcessCount = new AtomicInteger(0);

        private FrontEndCacheObject(ITransactionElement frondEndTxEle) {
            this.fFrondEndTxEle = frondEndTxEle;
            this.fProcessCount.incrementAndGet();
        }

        public void incrementProcessCount() {
            this.fProcessCount.incrementAndGet();
        }

        public int decrementProcessCount() {
            return this.fProcessCount.decrementAndGet();
        }

        public ITransactionElement getFrondEndTxEle() {
            return this.fFrondEndTxEle;
        }
    }
}

