/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.StreamMap;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.org.apache.commons.io.output.ByteArrayOutputStream;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TibcoBWUtils {
    private static final Module kModule = new Module("TibcoBW");
    protected static Map<ClassLoader, ClassLoader> tibcoClassLoaders = new HashMap<ClassLoader, ClassLoader>();
    public static final String CUSTOMCLASSLOADERJAR = "tibcobw-agent.jar";
    private static final String KLINESEPARATORPROPERTYNAME = "line.separator";
    private static boolean kIsMBBSEnabled;
    private static boolean kIsSerializationEnabled;
    private static boolean kIsCorrelationSOAPReadEnabled;
    private static boolean kIsCorrelationSOAPInsertionEnabled;
    private static boolean kIsCorrelationHTTPReadEnabled;
    private static boolean kIsCorrelationHTTPInsertionEnabled;
    private static boolean kIsCorrelationJMSReadEnabled;
    private static boolean kIsCorrelationJMSInsertionEnabled;
    private static ProtectedLogger sLogger;

    static {
        try {
            kIsMBBSEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.soaextension.tibcobw.mbbs.enabled", true);
        }
        catch (Exception exception) {
            kIsMBBSEnabled = true;
        }
        try {
            kIsCorrelationSOAPReadEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.soapheaderread.enabled", true);
        }
        catch (Exception exception) {
            kIsCorrelationSOAPReadEnabled = true;
        }
        try {
            kIsCorrelationHTTPReadEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.httpheaderread.enabled", true);
        }
        catch (Exception exception) {
            kIsCorrelationSOAPReadEnabled = true;
        }
        try {
            kIsCorrelationJMSReadEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.jmsheaderread.enabled", true);
        }
        catch (Exception exception) {
            kIsCorrelationJMSReadEnabled = true;
        }
        try {
            kIsCorrelationSOAPInsertionEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.soapheaderinsertion.enabled", true);
        }
        catch (Exception exception) {
            kIsCorrelationSOAPInsertionEnabled = true;
        }
        try {
            kIsCorrelationHTTPInsertionEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.httpheaderinsertion.enabled", true);
        }
        catch (Exception exception) {
            kIsCorrelationHTTPInsertionEnabled = true;
        }
        try {
            kIsCorrelationJMSInsertionEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.jmsheaderinsertion.enabled", true);
        }
        catch (Exception exception) {
            kIsCorrelationJMSInsertionEnabled = true;
        }
        try {
            kIsSerializationEnabled = TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.soaextension.tibcobw.correlationserialization.enabled", true);
        }
        catch (Exception exception) {
            kIsSerializationEnabled = true;
        }
        sLogger = new ProtectedLogger();
    }

    private TibcoBWUtils() {
    }

    public static boolean iskIsCorrelationSOAPReadEnabled() {
        return kIsCorrelationSOAPReadEnabled;
    }

    public static void setkIsCorrelationSOAPReadEnabled(boolean kIsCorrelationSOAPReadEnabled) {
        TibcoBWUtils.kIsCorrelationSOAPReadEnabled = kIsCorrelationSOAPReadEnabled;
    }

    public static boolean iskIsCorrelationSOAPInsertionEnabled() {
        return kIsCorrelationSOAPInsertionEnabled;
    }

    public static void setkIsCorrelationSOAPInsertionEnabled(boolean kIsCorrelationSOAPInsertionEnabled) {
        TibcoBWUtils.kIsCorrelationSOAPInsertionEnabled = kIsCorrelationSOAPInsertionEnabled;
    }

    public static boolean iskIsCorrelationHTTPReadEnabled() {
        return kIsCorrelationHTTPReadEnabled;
    }

    public static void setkIsCorrelationHTTPReadEnabled(boolean kIsCorrelationHTTPReadEnabled) {
        TibcoBWUtils.kIsCorrelationHTTPReadEnabled = kIsCorrelationHTTPReadEnabled;
    }

    public static boolean iskIsCorrelationHTTPInsertionEnabled() {
        return kIsCorrelationHTTPInsertionEnabled;
    }

    public static void setkIsCorrelationHTTPInsertionEnabled(boolean kIsCorrelationHTTPInsertionEnabled) {
        TibcoBWUtils.kIsCorrelationHTTPInsertionEnabled = kIsCorrelationHTTPInsertionEnabled;
    }

    public static boolean iskIsCorrelationJMSReadEnabled() {
        return kIsCorrelationJMSReadEnabled;
    }

    public static void setkIsCorrelationJMSReadEnabled(boolean kIsCorrelationJMSReadEnabled) {
        TibcoBWUtils.kIsCorrelationJMSReadEnabled = kIsCorrelationJMSReadEnabled;
    }

    public static boolean iskIsCorrelationJMSInsertionEnabled() {
        return kIsCorrelationJMSInsertionEnabled;
    }

    public static void setkIsCorrelationJMSInsertionEnabled(boolean kIsCorrelationJMSInsertionEnabled) {
        TibcoBWUtils.kIsCorrelationJMSInsertionEnabled = kIsCorrelationJMSInsertionEnabled;
    }

    public static Module getModule() {
        return kModule;
    }

    public static Object invokeMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = clazz.getMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    public static Object invokeParentMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            try {
                method = clazz.getMethod(methodName, parameterTypes);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        if (method != null) {
            return method.invoke(object, args);
        }
        return null;
    }

    public static Object invokeMethodOnObject(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return TibcoBWUtils.invokeMethodOnObject(object, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return TibcoBWUtils.invokeMethodOnClass(clazz, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(null, args);
    }

    public static Object getField(Object object, String fieldName) throws IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = TibcoReflectionCache.getFieldReflection(fieldName, clazz, true);
        if (field == null) {
            field = TibcoReflectionCache.getFieldReflection(fieldName, clazz, false);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        if (field != null) {
            return field.get(object);
        }
        return null;
    }

    public static Object getParentField(Object object, String fieldName) throws IllegalAccessException {
        Field field = null;
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        if (field != null) {
            return field.get(object);
        }
        return null;
    }

    public static String resource2URI(String resource) {
        int index;
        if (resource != null && (index = resource.indexOf(95)) != -1) {
            StringBuilder buf = new StringBuilder(resource);
            buf.setCharAt(index, ':');
            resource = buf.toString();
        }
        return resource;
    }

    public static String uri2Resource(String uri) {
        int index;
        if (uri != null && (index = uri.indexOf(58)) != -1) {
            StringBuilder buf = new StringBuilder(uri);
            buf.setCharAt(index, '_');
            uri = buf.toString();
        }
        return uri;
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])KConstants.KILLEGALRESOURCECHARS, (char)'_');
    }

    public static String formatURLToBeResourceSafe(String url) {
        String newURL = null;
        StringBuilder newURLBuffer = new StringBuilder();
        if (url != null) {
            StringTokenizer strTok = new StringTokenizer(url, ":@=&$-+!*'(),");
            int tokens = strTok.countTokens();
            int x = 0;
            while (x < tokens) {
                String token = strTok.nextToken();
                if (!token.equals("")) {
                    newURLBuffer.append(token).append("_");
                }
                ++x;
            }
            if (newURLBuffer.length() < 2) {
                newURL = null;
            } else {
                String tempURL = newURLBuffer.toString();
                newURL = tempURL.trim().substring(0, tempURL.length() - 1);
            }
        }
        return newURL;
    }

    public static void handleError(IAgent agent, String localizedKey, Throwable t) {
        if (TibcoBWUtils.getLogger().isVerboseEnabled()) {
            TibcoBWUtils.getLogger().verbose(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey), t);
        } else {
            TibcoBWUtils.getLogger().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
        }
    }

    public static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgent();
    }

    public static IModuleFeedbackChannel getAgentLogger() throws AgentNotAvailableException {
        return TibcoBWUtils.getAgent().IAgent_getModuleFeedback();
    }

    public static IndexedProperties getAgentConfiguration() throws AgentNotAvailableException {
        return TibcoBWUtils.getAgent().IAgent_getIndexedProperties();
    }

    public static IModuleFeedbackChannel getLogger() {
        return sLogger;
    }

    public static String dumpStackTrace(Throwable bomb) {
        StackTracePrintStream stack = new StackTracePrintStream((OutputStream)new ByteArrayOutputStream(), 1024);
        bomb.printStackTrace(stack);
        return stack.getString();
    }

    public static IResource getDirFinder(String directoryName, String fileName) {
        ExtendedFile wilyDirectory = new ExtendedFile(directoryName);
        String fullPath = new ExtendedFile(wilyDirectory, fileName).safeGetCanonicalPath();
        return new FileBasedResource(fullPath);
    }

    public static String getAbsoluteAgentPath() {
        String path = "";
        try {
            IResource profileResource = TibcoBWUtils.getAgent().IAgent_getConfigurationResource();
            if (profileResource.IResource_isFileResource()) {
                File profileDirectory = new File(profileResource.IResource_getLocation()).getParentFile();
                File pathFile = new File(profileDirectory, path);
                path = pathFile.getAbsolutePath();
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            path = "wily";
        }
        return path;
    }

    public static String getExtensionDirectory() {
        String extFolder = "";
        try {
            IndexedProperties props = TibcoBWUtils.getAgentConfiguration();
            extFolder = props.getTrimmedProperty("introscope.agent.extensions.directory");
        }
        catch (AgentNotAvailableException bomb) {
            TibcoBWUtils.getLogger().error("getExtensionDirectory " + TibcoBWUtils.dumpStackTrace(bomb));
        }
        return extFolder;
    }

    public static URLClassLoader createClassLoader(ClassLoader parent, String customClassLoaderJarFile) throws MalformedURLException {
        URLClassLoader urlClassLoader = null;
        IResource resource = TibcoBWUtils.getDirFinder(String.valueOf(TibcoBWUtils.getAbsoluteAgentPath()) + File.separator + TibcoBWUtils.getExtensionDirectory() + File.separator, customClassLoaderJarFile);
        URL[] urlResources = new URL[]{resource.IResource_getURL()};
        urlClassLoader = new URLClassLoader(urlResources, parent);
        return urlClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setClassLoader(Object o) {
        ClassLoader parent = o.getClass().getClassLoader();
        ClassLoader tibcoClassLoader = null;
        Map<ClassLoader, ClassLoader> map = tibcoClassLoaders;
        synchronized (map) {
            if (tibcoClassLoaders.size() == 1) {
                Collection<ClassLoader> c = tibcoClassLoaders.values();
                Object[] co = c.toArray();
                return (ClassLoader)co[0];
            }
            tibcoClassLoader = tibcoClassLoaders.get(parent);
            String nameparent = "";
            String name = "";
            if (tibcoClassLoader != null) {
                if (tibcoClassLoader.getParent() != null) {
                    nameparent = tibcoClassLoader.getParent().getClass().getName();
                    TibcoBWUtils.getLogger().debug("adding nameparent: " + nameparent);
                }
                name = tibcoClassLoaders.getClass().getName();
                TibcoBWUtils.getLogger().debug("adding classloaders: " + name);
            } else {
                try {
                    tibcoClassLoader = TibcoBWUtils.createClassLoader(parent, CUSTOMCLASSLOADERJAR);
                    name = parent.getClass().getName();
                    TibcoBWUtils.getLogger().debug("adding classloaders: " + name);
                    tibcoClassLoaders.put(parent, tibcoClassLoader);
                }
                catch (Exception e) {
                    if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                        TibcoBWUtils.getLogger().debug(e.getMessage());
                    }
                    return o.getClass().getClassLoader();
                }
            }
            TibcoBWUtils.getLogger().debug(String.valueOf(tibcoClassLoaders.size()) + " classloaders in hash");
        }
        return tibcoClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setClassLoader(ClassLoader cl) {
        ClassLoader tibcoClassLoader = null;
        Map<ClassLoader, ClassLoader> map = tibcoClassLoaders;
        synchronized (map) {
            tibcoClassLoader = tibcoClassLoaders.get(cl);
            if (tibcoClassLoader == null) {
                try {
                    tibcoClassLoader = TibcoBWUtils.createClassLoader(cl, CUSTOMCLASSLOADERJAR);
                    tibcoClassLoaders.put(cl, tibcoClassLoader);
                }
                catch (Exception e) {
                    if (TibcoBWUtils.getLogger().isDebugEnabled()) {
                        TibcoBWUtils.getLogger().debug(e.getMessage());
                    }
                    return cl;
                }
            }
            TibcoBWUtils.getLogger().debug(String.valueOf(tibcoClassLoaders.size()) + " classloaders in hash");
        }
        return tibcoClassLoader;
    }

    public static Class getClassFromInvocationObjectLoader(String className, InvocationData data) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)data.get(className);
        if (clazz == null) {
            String classNameString = data.getInvocationObject().getClass().getName();
            ClassLoader cl = data.getInvocationObject().getClass().getClassLoader();
            if (classNameString.indexOf("com.wily") >= 0) {
                cl = cl.getParent();
            }
            TibcoBWUtils.getLogger().debug("ANameFormatter.getClassFromInvocationObjectLoader(): " + data.getInvocationObject().getClass().getName());
            ClassLoader classLoader = TibcoBWUtils.setClassLoader(cl);
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                data.put(className, clazz);
            } else {
                TibcoBWUtils.getLogger().error("anameformatter, classloader is null");
            }
        }
        return clazz;
    }

    public static boolean correlationSOAPReadEnabled() {
        return kIsCorrelationSOAPReadEnabled;
    }

    public static boolean correlationJMSReadEnabled() {
        return kIsCorrelationJMSReadEnabled;
    }

    public static boolean correlationHTTPReadEnabled() {
        return kIsCorrelationHTTPReadEnabled;
    }

    public static boolean correlationSOAPInsertionEnabled() {
        return kIsCorrelationSOAPInsertionEnabled;
    }

    public static boolean correlationHTTPInsertionEnabled() {
        return kIsCorrelationHTTPInsertionEnabled;
    }

    public static boolean correlationJMSInsertionEnabled() {
        return kIsCorrelationJMSInsertionEnabled;
    }

    public static boolean isMBBSEnabled() {
        return kIsMBBSEnabled;
    }

    public static boolean isHawkMonitorEnabled() {
        try {
            return TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.soaextension.tibcobw.hawkmonitor.enabled", false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean getHawkPropertyValue(String property) {
        try {
            return TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty(property, true);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isTibcoEngineThread() {
        try {
            return Thread.currentThread().getName().contains("JobCourier");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static long getJobMonitorfreq() {
        try {
            IAgent agent = TibcoBWUtils.getAgent();
            return agent.IAgent_getIndexedProperties().getLongProperty("com.wily.soaextension.tibcobw.jobmointor.frequency", 30000L);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return 30000L;
        }
    }

    public static boolean isJobMonitoringEnabled() {
        try {
            return TibcoBWUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.soaextension.tibcobw.jobmonitor.enabled", true);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isSerializationEnabled() {
        return kIsSerializationEnabled;
    }

    public static boolean isSocketBackend(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        return invocationObject instanceof InputStream || invocationObject instanceof OutputStream || invocationObject instanceof SocketChannel || invocationObject instanceof DatagramChannel;
    }

    public static boolean isSocketBackendTracingRequired(InvocationData data, IAgent agent) {
        InetSocketAddress remoteAddress;
        AbstractSelectableChannel channel;
        Object invocationObject = data.getInvocationObject();
        if ((invocationObject instanceof InputStream || invocationObject instanceof OutputStream) && StreamMap.isRequired((Object)invocationObject, (IAgent)agent)) {
            return StreamMap.isClientConnection((Object)invocationObject);
        }
        if (invocationObject instanceof SocketChannel && SocketChannelMap.isRequired((Object)(channel = (SocketChannel)invocationObject), (IAgent)agent)) {
            return SocketChannelMap.isClientConnection((Object)channel);
        }
        if (data.getInvocationObject() instanceof DatagramChannel && DatagramChannelMap.isRequired((DatagramChannel)(channel = (DatagramChannel)data.getInvocationObject()), (InetSocketAddress)(remoteAddress = (InetSocketAddress)((DatagramChannel)channel).socket().getRemoteSocketAddress()), (IAgent)agent)) {
            return DatagramChannelMap.isClientConnection((DatagramChannel)channel, (InetSocketAddress)remoteAddress);
        }
        if (data.getInvocationObject() instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(1) instanceof InetSocketAddress && DatagramChannelMap.isClientConnection((DatagramChannel)(channel = (DatagramChannel)data.getInvocationObject()), (InetSocketAddress)(remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(1)))) {
            return DatagramChannelMap.isClientRequired((DatagramChannel)channel, (InetSocketAddress)remoteAddress, (IAgent)agent);
        }
        return false;
    }

    private static class ProtectedLogger
    implements IModuleFeedbackChannel {
        private ProtectedLogger() {
        }

        private synchronized IModuleFeedbackChannel getFeedbackChannel() {
            IModuleFeedbackChannel channel;
            block2: {
                channel = null;
                try {
                    channel = TibcoBWUtils.getAgentLogger();
                }
                catch (AgentNotAvailableException e) {
                    if (!TibcoBWUtils.getLogger().isDebugEnabled()) break block2;
                    TibcoBWUtils.getLogger().debug(e.getMessage());
                }
            }
            return channel;
        }

        public boolean isVerboseEnabled() {
            boolean verbose = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                verbose = channel.isVerboseEnabled(TibcoBWUtils.getModule());
            }
            return verbose;
        }

        public boolean isDebugEnabled() {
            boolean debug = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                debug = channel.isDebugEnabled(TibcoBWUtils.getModule());
            }
            return debug;
        }

        public boolean isTraceEnabled() {
            boolean trace = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                trace = channel.isTraceEnabled(TibcoBWUtils.getModule());
            }
            return trace;
        }

        public boolean isErrorEnabled(Module module) {
            boolean error = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                error = channel.isErrorEnabled(module);
            }
            return error;
        }

        public boolean isWarningEnabled(Module module) {
            boolean warn = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                warn = channel.isWarningEnabled(module);
            }
            return warn;
        }

        public boolean isInfoEnabled(Module module) {
            boolean info = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                info = channel.isInfoEnabled(module);
            }
            return info;
        }

        public boolean isVerboseEnabled(Module module) {
            boolean verbose = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                verbose = channel.isVerboseEnabled(module);
            }
            return verbose;
        }

        public boolean isDebugEnabled(Module module) {
            boolean debug = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                debug = channel.isDebugEnabled(module);
            }
            return debug;
        }

        public boolean isTraceEnabled(Module module) {
            boolean trace = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                trace = channel.isTraceEnabled(module);
            }
            return trace;
        }

        public boolean isLogEnabled(SeverityLevel severityLevel, Module module) {
            boolean log = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                log = channel.isLogEnabled(severityLevel, module);
            }
            return log;
        }

        public void error(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(TibcoBWUtils.getModule(), string);
            }
        }

        public void error(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(TibcoBWUtils.getModule(), string, throwable);
            }
        }

        public void warn(String string) {
            IModuleFeedbackChannel channel;
            if (this.isWarningEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(TibcoBWUtils.getModule(), string);
            }
        }

        public void warn(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (this.isWarningEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(TibcoBWUtils.getModule(), string, throwable);
            }
        }

        public void info(String string) {
            IModuleFeedbackChannel channel;
            if (this.isInfoEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.info(TibcoBWUtils.getModule(), string);
            }
        }

        public void info(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (this.isInfoEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.info(TibcoBWUtils.getModule(), string, throwable);
            }
        }

        public void verbose(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(TibcoBWUtils.getModule(), string);
            }
        }

        public void verbose(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(TibcoBWUtils.getModule(), string, throwable);
            }
        }

        public void debug(String string) {
            IModuleFeedbackChannel channel;
            if (this.isDebugEnabled() && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(TibcoBWUtils.getModule(), string);
            }
        }

        public void debug(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (this.isDebugEnabled() && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(TibcoBWUtils.getModule(), string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, TibcoBWUtils.getModule(), string);
            }
        }

        public void log(SeverityLevel severityLevel, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, TibcoBWUtils.getModule(), string, throwable);
            }
        }

        public void error(Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(TibcoBWUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void verbose(Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(TibcoBWUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void debug(Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (this.isDebugEnabled() && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(TibcoBWUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void error(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(module, string);
            }
        }

        public void error(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(module, string, throwable);
            }
        }

        public void warn(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (this.isWarningEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(module, string);
            }
        }

        public void warn(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (this.isWarningEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(module, string, throwable);
            }
        }

        public void info(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (this.isInfoEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.info(module, string);
            }
        }

        public void info(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (this.isInfoEnabled(TibcoBWUtils.getModule()) && (channel = this.getFeedbackChannel()) != null) {
                channel.info(module, string, throwable);
            }
        }

        public void verbose(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(module, string);
            }
        }

        public void verbose(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(module, string, throwable);
            }
        }

        public void debug(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (this.isDebugEnabled() && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(module, string);
            }
        }

        public void debug(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (this.isDebugEnabled() && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(module, string, throwable);
            }
        }

        public void trace(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(TibcoBWUtils.getModule(), string);
            }
        }

        public void trace(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(TibcoBWUtils.getModule(), string, throwable);
            }
        }

        public void trace(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(module, string);
            }
        }

        public void trace(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(module, string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, module, string);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, module, string, throwable);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.logImmediate(severityLevel, module, string);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.logImmediate(severityLevel, module, string, throwable);
            }
        }

        public void setLevel(SeverityLevel level, Module module) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.setLevel(level, module);
            }
        }

        public SeverityLevel getLevel(Module module) {
            SeverityLevel level = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                level = channel.getLevel(module);
            }
            return level;
        }

        public SeverityLevel getEffectiveLevel(Module module) {
            SeverityLevel level = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                level = channel.getEffectiveLevel(module);
            }
            return level;
        }

        public String getApplicationName() {
            String appName = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                appName = channel.getApplicationName();
            }
            return appName;
        }

        public String getModuleName() {
            String name = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                name = channel.getModuleName();
            }
            return name;
        }
    }

    private static class StackTracePrintStream
    extends PrintStream {
        private final char[] fLineSeparator = System.getProperty("line.separator").toCharArray();
        private int fCursor = 0;
        private char[] fChars;
        private int fCharCount;

        public StackTracePrintStream(OutputStream dummy, int initialSize) {
            super(dummy);
            this.fChars = new char[initialSize];
            this.fCharCount = initialSize;
        }

        @Override
        public synchronized void print(char[] data) {
            while (this.fCursor + data.length > this.fCharCount) {
                this.growBuffer();
            }
            System.arraycopy(data, 0, this.fChars, this.fCursor, data.length);
            this.fCursor += data.length;
        }

        @Override
        public synchronized void print(String s) {
            if (s == null) {
                s = "null";
            }
            int length = s.length();
            while (this.fCursor + length > this.fCharCount) {
                this.growBuffer();
            }
            s.getChars(0, length, this.fChars, this.fCursor);
            this.fCursor += length;
        }

        @Override
        public synchronized void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        @Override
        public synchronized void println(char[] data) {
            this.print(data);
            this.printSeparator();
        }

        @Override
        public synchronized void println(String s) {
            this.print(s);
            this.printSeparator();
        }

        @Override
        public synchronized void println(Object obj) {
            this.print(obj);
            this.printSeparator();
        }

        @Override
        public synchronized void println() {
            this.printSeparator();
        }

        private void printSeparator() {
            this.print(this.fLineSeparator);
        }

        private void growBuffer() {
            int newSize = this.fCharCount * 2;
            char[] newBuffer = new char[newSize];
            System.arraycopy(this.fChars, 0, newBuffer, 0, this.fCharCount);
            this.fCharCount = newSize;
            this.fChars = newBuffer;
        }

        public String getString() {
            return new String(this.fChars, 0, this.fCursor);
        }

        public void reset() {
            this.fCursor = 0;
        }

        @Override
        public void flush() {
        }
    }
}

