/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.webservice.nameformatter.WebServiceNameHelper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HTTPWebServiceFrontendNameFormatter
implements INameFormatter {
    private static final String SOAPACTION = "{SoapAction}";
    private static final String URI = "{URI}";
    private static final String EMPTYSTRING = "";
    private static final Class[] EMPTYCLASSARRAY = new Class[0];
    private static final String DEFAULT = "Default";
    private static final String GET_SOAP_ACTION = "getSoapAction";
    private static final String TIBCO_PRODUCER_SOAP_ACTION = "Tibco.Producer.soapAction";
    private static final String HTTP = "http://";
    private static final String GET_TRANSPORT_URI = "getTransportUri";
    private static final String TIBCO_PRODUCER_URI = "Tibco.Producer.uri";
    private static final String TIBCO_PRODUCER_T_CONTEXT = "Tibco.Producer.tContext";
    private static final String GET_TRANSPORT_CONTEXT = "getTransportContext";
    private static Module sModule = new Module("Tibco WebService Producer Tracer");
    private IModuleFeedbackChannel log;
    private IAgent agent;
    private static Method getSoapActionMethod;
    private static Method getTransportContextMethod;
    private static Method getUriMethod;

    private static Module getsModule() {
        return sModule;
    }

    private static Method getGetSoapActionMethod() {
        return getSoapActionMethod;
    }

    private static void setGetSoapActionMethod(Method getSoapActionMethod) {
        HTTPWebServiceFrontendNameFormatter.getSoapActionMethod = getSoapActionMethod;
    }

    private static Method getGetTransportContextMethod() {
        return getTransportContextMethod;
    }

    private static void setGetTransportContextMethod(Method getTransportContextMethod) {
        HTTPWebServiceFrontendNameFormatter.getTransportContextMethod = getTransportContextMethod;
    }

    private static Method getGetUriMethod() {
        return getUriMethod;
    }

    private static void setGetUriMethod(Method getUriMethod) {
        HTTPWebServiceFrontendNameFormatter.getUriMethod = getUriMethod;
    }

    public HTTPWebServiceFrontendNameFormatter(IAgent agent) {
        this.agent = agent;
    }

    public String INameFormatter_format(String componet, InvocationData data) {
        String formattedName = componet;
        if (formattedName.contains(URI)) {
            String transportUI = this.getTransportUri(data);
            transportUI = WebServiceNameHelper.removeTrailingPipe(transportUI);
            formattedName = formattedName.replace(URI, transportUI);
        }
        if (formattedName.contains(SOAPACTION)) {
            String soapAction = this.getSoapAction(data);
            formattedName = formattedName.replace(SOAPACTION, soapAction);
        }
        return formattedName;
    }

    private Object getTransportContext(InvocationData data) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object transportContext = data.get(TIBCO_PRODUCER_T_CONTEXT);
        if (transportContext == null) {
            Object transportMessageObject = data.getInvocationParameterAsObject(0);
            if (HTTPWebServiceFrontendNameFormatter.getGetTransportContextMethod() == null) {
                HTTPWebServiceFrontendNameFormatter.setGetTransportContextMethod(transportMessageObject.getClass().getMethod(GET_TRANSPORT_CONTEXT, EMPTYCLASSARRAY));
                getTransportContextMethod.setAccessible(true);
            }
            transportContext = getTransportContextMethod.invoke(transportMessageObject, new Object[0]);
            data.put(TIBCO_PRODUCER_T_CONTEXT, transportContext);
        }
        return transportContext;
    }

    private String getSoapAction(InvocationData data) {
        String soapAction = (String)data.get(TIBCO_PRODUCER_SOAP_ACTION);
        if (soapAction == null || soapAction.trim().equals(EMPTYSTRING)) {
            try {
                Object transportContext = this.getTransportContext(data);
                if (HTTPWebServiceFrontendNameFormatter.getGetSoapActionMethod() == null) {
                    HTTPWebServiceFrontendNameFormatter.setGetSoapActionMethod(transportContext.getClass().getMethod(GET_SOAP_ACTION, EMPTYCLASSARRAY));
                    getSoapActionMethod.setAccessible(true);
                }
                soapAction = (soapAction = (String)getSoapActionMethod.invoke(transportContext, new Object[0])) == null || soapAction.trim().equals(EMPTYSTRING) ? DEFAULT : soapAction.replace('\"', ' ').trim();
                data.put(TIBCO_PRODUCER_SOAP_ACTION, (Object)soapAction);
                return soapAction;
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
                this.log.error(HTTPWebServiceFrontendNameFormatter.getsModule(), "Error in getting Soap Action");
                return DEFAULT;
            }
        }
        return WebServiceNameHelper.removeTrailingPipe(soapAction);
    }

    private String getTransportUri(InvocationData data) {
        String transportURI = (String)data.get(TIBCO_PRODUCER_URI);
        if (transportURI == null || transportURI.trim().equals(EMPTYSTRING)) {
            try {
                Object uriObject;
                Object transportContext = this.getTransportContext(data);
                if (HTTPWebServiceFrontendNameFormatter.getGetUriMethod() == null) {
                    HTTPWebServiceFrontendNameFormatter.setGetUriMethod(transportContext.getClass().getMethod(GET_TRANSPORT_URI, EMPTYCLASSARRAY));
                    getUriMethod.setAccessible(true);
                }
                if ((uriObject = getUriMethod.invoke(transportContext, new Object[0])) != null) {
                    transportURI = uriObject.toString().replaceAll(HTTP, EMPTYSTRING);
                    transportURI = transportURI.substring(transportURI.indexOf(47) + 1).trim();
                    if (!(transportURI = WebServiceNameHelper.removeTrailingPipe(transportURI)).trim().equals(EMPTYSTRING)) {
                        data.put(TIBCO_PRODUCER_URI, (Object)transportURI);
                        return WebServiceNameHelper.removeTrailingPipe(transportURI);
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
                this.log.error(sModule, "Error in getting Transport Uri");
            }
            return DEFAULT;
        }
        return WebServiceNameHelper.removeTrailingPipe(transportURI);
    }
}

