/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatter;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebServicesClientFormatter
extends BWGenericFormatter {
    private static final String C_SOAP_JMS_REQUESTOR = "com.tibco.bw.soap.share.reqrep.SoapJmsRequestor";

    public WebServicesClientFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object service;
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive)) != null && (service = TibcoReflectionCache.getFSoapRequestorISoapServiceConfig(requestor)) != null) {
                namespace = (String)TibcoReflectionCache.getFSoapCommonConfigWsdlNamespace(service);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getNamespace: " + namespace);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    @Override
    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null) {
                webServiceURI = this.duringSoapSendReceiveExist(soapSendReceive);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    private String duringSoapSendReceiveExist(Object soapSendReceive) throws SecurityException, NoSuchFieldException, IllegalAccessException {
        String webServiceURI = null;
        Object requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive);
        if (requestor != null) {
            if (requestor.getClass().getName().equalsIgnoreCase(C_SOAP_JMS_REQUESTOR)) {
                Object engineConfig = TibcoReflectionCache.getFSoapRequestorSoapEngineConfig(requestor);
                if (engineConfig != null) {
                    webServiceURI = this.duringEngineConfigExist(engineConfig);
                }
            } else {
                Object endpointConfig = TibcoReflectionCache.getFSoapHttpRequestorSoapEndpointConfig(requestor);
                if (endpointConfig != null) {
                    webServiceURI = (String)TibcoReflectionCache.getFSoapEndpointConfigurationkString(endpointConfig);
                }
            }
        }
        return webServiceURI;
    }

    private String duringEngineConfigExist(Object engineConfig) throws SecurityException, NoSuchFieldException, IllegalAccessException {
        String webServiceURI = null;
        Map urlToServiceConfigListMap = (Map)TibcoReflectionCache.getFSoapEngineConfigUrlToServiceConfigListMap(engineConfig);
        if (urlToServiceConfigListMap != null) {
            Set col = urlToServiceConfigListMap.keySet();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                webServiceURI = itr.next().toString();
            }
        }
        return webServiceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive)) != null) {
                operationName = (String)TibcoReflectionCache.getFSoapRequestorOperationName(requestor);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getOperationName: " + operationName);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals("UnknownOperationName") ? "UnknownOperationName" : operationName;
    }
}

