/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatterHC;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebServicesClientFormatterHC
extends BWGenericFormatterHC {
    private static final String C_SOAP_JMS_REQUESTOR = "com.tibco.bw.soap.share.reqrep.SoapJmsRequestor";

    public WebServicesClientFormatterHC(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object service;
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive)) != null && (service = TibcoReflectionCache.getFSoapRequestorISoapServiceConfig(requestor)) != null) {
                namespace = (String)TibcoReflectionCache.getFSoapCommonConfigWsdlNamespace(service);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getNamespace: " + namespace);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    @Override
    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive)) != null) {
                webServiceURI = this.duringRequestorExist(requestor, webServiceURI);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    private String duringRequestorExist(Object requestor, String webServiceURI) throws NoSuchFieldException, IllegalAccessException {
        if (requestor.getClass().getName().equalsIgnoreCase(C_SOAP_JMS_REQUESTOR)) {
            Map urlToServiceConfigListMap;
            Object engineConfig = TibcoReflectionCache.getFSoapRequestorSoapEngineConfig(requestor);
            if (engineConfig != null && (urlToServiceConfigListMap = (Map)TibcoReflectionCache.getFSoapEngineConfigUrlToServiceConfigListMap(engineConfig)) != null) {
                Set col = urlToServiceConfigListMap.keySet();
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    webServiceURI = itr.next().toString();
                }
            }
        } else {
            Object endpointConfig = TibcoReflectionCache.getFSoapHttpRequestorSoapEndpointConfig(requestor);
            if (endpointConfig != null) {
                webServiceURI = (String)TibcoReflectionCache.getFSoapEndpointConfigurationkString(endpointConfig);
            }
        }
        return webServiceURI;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData invocationdata) {
        String namespace = this.getNamespace(invocationdata);
        invocationdata.put("com.wily.soaextension.tibcobw.NamespaceKey", (Object)namespace);
        return ABlameComponent.getArrayInstance((Object[])new Object[]{name, namespace});
    }
}

